/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class SessionAddMetaDataMessage
extends PacketImpl {
    private String key;
    private String data;

    public SessionAddMetaDataMessage() {
        super((byte)104);
    }

    public SessionAddMetaDataMessage(String k, String d) {
        this();
        this.key = k;
        this.data = d;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeString(this.key);
        buffer.writeString(this.data);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.key = buffer.readString();
        this.data = buffer.readString();
    }

    @Override
    public final boolean isRequiresConfirmations() {
        return false;
    }

    public String getKey() {
        return this.key;
    }

    public String getData() {
        return this.data;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.data, this.key);
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", key=" + this.key);
        sb.append(", data=" + this.data);
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionAddMetaDataMessage)) {
            return false;
        }
        SessionAddMetaDataMessage other = (SessionAddMetaDataMessage)obj;
        return Objects.equals(this.data, other.data) && Objects.equals(this.key, other.key);
    }
}

