/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.shallow;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.wildfly.extension.messaging.activemq.shallow.ShallowResourceDefinition;

public class TranslatedWriteAttributeHandler
implements OperationStepHandler {
    private static final Logger LOG = Logger.getLogger(TranslatedWriteAttributeHandler.class);
    private final ShallowResourceDefinition shallowResource;

    public TranslatedWriteAttributeHandler(ShallowResourceDefinition shallowResource) {
        this.shallowResource = shallowResource;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress targetAddress = this.shallowResource.convert(context, operation);
        ModelNode op = operation.clone();
        op.get("address").set(targetAddress.toModelNode());
        String attributeName = op.get("name").asString();
        if (!this.shallowResource.getIgnoredAttributes(context, op).contains(attributeName)) {
            this.shallowResource.validateOperation(context, targetAddress, op);
            OperationStepHandler writeAttributeHandler = context.getRootResourceRegistration().getAttributeAccess(targetAddress, attributeName).getWriteHandler();
            context.addStep(op, writeAttributeHandler, context.getCurrentStage(), true);
        } else {
            LOG.debugf("Ignoring write operation on resource %s, attribute %s. The attribute is ignored.", (Object)targetAddress.toString(), (Object)attributeName);
        }
    }
}

