/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.time;

import java.io.IOException;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.FieldSetReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.time.LocalTimeMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.ZoneOffsetMarshaller;

public enum OffsetTimeMarshaller implements ProtoStreamMarshaller<OffsetTime>
{
    INSTANCE;

    private static final int TIME_INDEX = 1;
    private static final int OFFSET_INDEX;

    @Override
    public OffsetTime readFrom(ProtoStreamReader reader) throws IOException {
        FieldSetReader<LocalTime> timeReader = reader.createFieldSetReader(LocalTimeMarshaller.INSTANCE, 1);
        FieldSetReader<ZoneOffset> offsetReader = reader.createFieldSetReader(ZoneOffsetMarshaller.INSTANCE, OFFSET_INDEX);
        LocalTime time = LocalTimeMarshaller.INSTANCE.createInitialValue();
        ZoneOffset offset = ZoneOffsetMarshaller.INSTANCE.createInitialValue();
        while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            if (timeReader.contains(index)) {
                time = timeReader.readField(time);
                continue;
            }
            if (offsetReader.contains(index)) {
                offset = offsetReader.readField(offset);
                continue;
            }
            reader.skipField(tag);
        }
        return OffsetTime.of(time, offset);
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, OffsetTime value) throws IOException {
        writer.createFieldSetWriter(LocalTimeMarshaller.INSTANCE, 1).writeFields(value.toLocalTime());
        writer.createFieldSetWriter(ZoneOffsetMarshaller.INSTANCE, OFFSET_INDEX).writeFields(value.getOffset());
    }

    @Override
    public Class<? extends OffsetTime> getJavaClass() {
        return OffsetTime.class;
    }

    static {
        OFFSET_INDEX = LocalTimeMarshaller.INSTANCE.nextIndex(1);
    }
}

