/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.api;

import io.smallrye.mutiny.Uni;
import io.smallrye.stork.api.LoadBalancer;
import io.smallrye.stork.api.ServiceDiscovery;
import io.smallrye.stork.api.ServiceInstance;
import io.smallrye.stork.api.ServiceRegistrar;
import io.smallrye.stork.api.observability.ObservationCollector;
import io.smallrye.stork.api.observability.StorkObservation;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Semaphore;

public class Service {
    private final Semaphore instanceSelectionLock;
    private final LoadBalancer loadBalancer;
    private final ServiceDiscovery serviceDiscovery;
    private final ServiceRegistrar<?> serviceRegistrar;
    private final String serviceName;
    private final String serviceDiscoveryType;
    private final String serviceSelectionType;
    private final ObservationCollector observations;

    public Service(String serviceName, String serviceSelectionType, String serviceDiscoveryType, ObservationCollector collector, LoadBalancer loadBalancer, ServiceDiscovery serviceDiscovery, ServiceRegistrar<?> serviceRegistrar, boolean requiresStrictRecording) {
        this.loadBalancer = loadBalancer;
        this.serviceDiscovery = serviceDiscovery;
        this.serviceRegistrar = serviceRegistrar;
        this.serviceDiscoveryType = serviceDiscoveryType;
        this.serviceSelectionType = serviceSelectionType;
        this.observations = collector;
        this.serviceName = serviceName;
        this.instanceSelectionLock = requiresStrictRecording ? new Semaphore(1) : null;
    }

    private Service(Builder builder) {
        this.serviceName = builder.serviceName;
        this.serviceSelectionType = builder.serviceSelectionType;
        this.serviceDiscoveryType = builder.serviceDiscoveryType;
        this.observations = builder.observations;
        this.loadBalancer = builder.loadBalancer;
        this.serviceDiscovery = builder.serviceDiscovery;
        this.serviceRegistrar = builder.serviceRegistrar;
        this.instanceSelectionLock = builder.requiresStrictRecording ? new Semaphore(1) : null;
    }

    public Uni<ServiceInstance> selectInstance() {
        StorkObservation observationPoints = this.observations.create(this.serviceName, this.serviceDiscoveryType, this.serviceSelectionType);
        return this.serviceDiscovery.getServiceInstances().onItemOrFailure().invoke((list, failure) -> {
            if (failure != null) {
                observationPoints.onServiceDiscoveryFailure((Throwable)failure);
            } else {
                observationPoints.onServiceDiscoverySuccess((List<ServiceInstance>)list);
            }
        }).map(this::selectInstance).onItemOrFailure().invoke((selected, failure) -> {
            if (failure != null) {
                observationPoints.onServiceSelectionFailure((Throwable)failure);
            } else {
                observationPoints.onServiceSelectionSuccess(selected.getId());
            }
        });
    }

    public ServiceInstance selectInstance(Collection<ServiceInstance> instances) {
        return this.loadBalancer.selectServiceInstance(instances);
    }

    public Uni<ServiceInstance> selectInstanceAndRecordStart(boolean measureTime) {
        StorkObservation observationPoints = this.observations.create(this.serviceName, this.serviceDiscoveryType, this.serviceSelectionType);
        return this.serviceDiscovery.getServiceInstances().onItemOrFailure().invoke((list, failure) -> {
            if (failure != null) {
                observationPoints.onServiceDiscoveryFailure((Throwable)failure);
            } else {
                observationPoints.onServiceDiscoverySuccess((List<ServiceInstance>)list);
            }
        }).map(list -> this.selectInstanceFromListAndRecordStart((Collection<ServiceInstance>)list, measureTime)).onItemOrFailure().invoke((selected, failure) -> {
            if (failure != null) {
                observationPoints.onServiceSelectionFailure((Throwable)failure);
            } else {
                observationPoints.onServiceSelectionSuccess(selected.getId());
            }
        });
    }

    public ServiceInstance selectInstanceFromListAndRecordStart(Collection<ServiceInstance> instances, boolean measureTime) {
        return this.doSelectInstanceFromListAndRecordStart(instances, measureTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceInstance doSelectInstanceFromListAndRecordStart(Collection<ServiceInstance> instances, boolean measureTime) {
        if (this.instanceSelectionLock == null) {
            ServiceInstance result = this.loadBalancer.selectServiceInstance(instances);
            if (result.gatherStatistics()) {
                result.recordStart(measureTime);
            }
            return result;
        }
        this.instanceSelectionLock.acquire();
        try {
            ServiceInstance result = this.loadBalancer.selectServiceInstance(instances);
            if (result.gatherStatistics()) {
                result.recordStart(measureTime);
            }
            ServiceInstance serviceInstance = result;
            this.instanceSelectionLock.release();
            return serviceInstance;
        }
        catch (Throwable throwable) {
            try {
                this.instanceSelectionLock.release();
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Failed to lock for ServiceInstance selection", e);
            }
        }
    }

    public ServiceInstance selectInstanceAndRecordStart(Collection<ServiceInstance> instances, boolean measureTime) {
        StorkObservation observationPoints = this.observations.create(this.serviceName, this.serviceDiscoveryType, this.serviceSelectionType);
        try {
            ServiceInstance result = this.doSelectInstanceFromListAndRecordStart(instances, measureTime);
            observationPoints.onServiceSelectionSuccess(result.getId());
            return result;
        }
        catch (RuntimeException e) {
            observationPoints.onServiceSelectionFailure(e);
            throw e;
        }
    }

    public Uni<List<ServiceInstance>> getInstances() {
        return this.serviceDiscovery.getServiceInstances();
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public ServiceDiscovery getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    public ServiceRegistrar getServiceRegistrar() {
        return this.serviceRegistrar;
    }

    public Uni<Void> registerInstance(String serviceName, String ipAddress, int port) {
        return this.serviceRegistrar.registerServiceInstance(serviceName, ipAddress, port);
    }

    public Uni<Void> registerInstance(ServiceRegistrar.RegistrarOptions options) {
        return this.serviceRegistrar.registerServiceInstance(options);
    }

    public Uni<Void> deregisterServiceInstance(String serviceName) {
        return this.serviceRegistrar.deregisterServiceInstance(serviceName);
    }

    public ObservationCollector getObservations() {
        return this.observations;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public static class Builder {
        private String serviceName;
        private final ObservationCollector observations;
        private ServiceDiscovery serviceDiscovery;
        private String serviceSelectionType = "round-robin";
        private String serviceDiscoveryType;
        private LoadBalancer loadBalancer;
        private ServiceRegistrar<?> serviceRegistrar;
        private boolean requiresStrictRecording = false;

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder(ObservationCollector observations) {
            this.observations = observations;
        }

        public Builder serviceDiscovery(ServiceDiscovery serviceDiscovery) {
            this.serviceDiscovery = serviceDiscovery;
            return this;
        }

        public Builder serviceSelectionType(String serviceSelectionType) {
            this.serviceSelectionType = serviceSelectionType;
            return this;
        }

        public Builder serviceDiscoveryType(String serviceDiscoveryType) {
            this.serviceDiscoveryType = serviceDiscoveryType;
            return this;
        }

        public Builder loadBalancer(LoadBalancer loadBalancer) {
            this.loadBalancer = loadBalancer;
            return this;
        }

        public Builder serviceRegistrar(ServiceRegistrar<?> serviceRegistrar) {
            this.serviceRegistrar = serviceRegistrar;
            return this;
        }

        public Builder requiresStrictRecording(boolean requiresStrictRecording) {
            this.requiresStrictRecording = requiresStrictRecording;
            return this;
        }

        public Service build() {
            return new Service(this);
        }
    }
}

