/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.commons.util.Util;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.impl.ExclusiveTargetRequest;
import org.infinispan.remoting.transport.impl.RequestRepository;
import org.infinispan.remoting.transport.jgroups.JGroupsMetricsManager;
import org.infinispan.remoting.transport.jgroups.RequestTracker;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class MultiTargetRequest<T>
extends ExclusiveTargetRequest<T> {
    private static final Log log = LogFactory.getLog(MultiTargetRequest.class);
    private final RequestTracker[] trackers;
    private int missingResponses;

    public MultiTargetRequest(ResponseCollector<T> responseCollector, long requestId, RequestRepository repository, Collection<Address> targets, Address excluded, JGroupsMetricsManager metricsCollector) {
        super(responseCollector, requestId, repository);
        this.trackers = new RequestTracker[targets.size()];
        int i = 0;
        for (Address target : targets) {
            if (excluded != null && excluded.equals(target)) continue;
            this.trackers[i++] = metricsCollector.trackRequest(target);
        }
        this.missingResponses = i;
        if (this.missingResponses == 0) {
            this.complete(responseCollector.finish());
        }
    }

    protected int getTargetsSize() {
        return this.trackers.length;
    }

    protected RequestTracker getTarget(int i) {
        return this.trackers[i];
    }

    @Override
    protected void actualOnResponse(Address sender, Response response) {
        try {
            boolean isDone = false;
            if (this.missingResponses <= 0) {
                return;
            }
            boolean invalidSender = true;
            for (int i = 0; i < this.trackers.length; ++i) {
                RequestTracker target = this.trackers[i];
                if (target == null || !target.destination().equals(sender)) continue;
                target.onComplete();
                invalidSender = false;
                this.trackers[i] = null;
                --this.missingResponses;
                break;
            }
            if (invalidSender) {
                if (log.isTraceEnabled()) {
                    log.tracef("Ignoring unexpected response to request %d from %s: %s", this.requestId, sender, response);
                }
                return;
            }
            Object result = this.responseCollector.addResponse(sender, response);
            if (result != null) {
                isDone = true;
                this.missingResponses = 0;
            } else if (this.missingResponses <= 0) {
                isDone = true;
                result = this.responseCollector.finish();
            }
            if (isDone) {
                this.complete(result);
            }
        }
        catch (Throwable t) {
            this.completeExceptionally(t);
        }
    }

    @Override
    protected boolean actualOnView(Set<Address> members) {
        boolean targetRemoved = false;
        try {
            boolean isDone = false;
            Object result = null;
            if (this.missingResponses <= 0) {
                return false;
            }
            for (int i = 0; i < this.trackers.length; ++i) {
                RequestTracker target = this.trackers[i];
                if (target == null || members.contains(target.destination())) continue;
                this.trackers[i] = null;
                --this.missingResponses;
                targetRemoved = true;
                if (log.isTraceEnabled()) {
                    log.tracef("Target %s of request %d left the cluster view", target, this.requestId);
                }
                if ((result = (Object)this.responseCollector.addResponse(target.destination(), CacheNotFoundResponse.INSTANCE)) == null) continue;
                isDone = true;
                break;
            }
            if (!isDone && this.missingResponses <= 0) {
                result = this.responseCollector.finish();
                isDone = true;
            }
            if (isDone) {
                this.complete(result);
            }
        }
        catch (Throwable t) {
            this.completeExceptionally(t);
        }
        return targetRemoved;
    }

    @Override
    protected void actualOnTimeout() {
        if (this.missingResponses <= 0) {
            return;
        }
        this.missingResponses = 0;
        String targetsWithoutResponses = Arrays.stream(this.trackers).filter(Objects::nonNull).peek(RequestTracker::onTimeout).map(RequestTracker::destination).map(Object::toString).collect(Collectors.joining(","));
        this.completeExceptionally(Log.CLUSTER.requestTimedOut(this.requestId, targetsWithoutResponses, Util.prettyPrintTime((long)this.getTimeoutMs())));
    }
}

