/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.ListenerRegistry;
import java.util.function.Consumer;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.undertow.AbstractHttpListenerResourceDefinition;
import org.wildfly.extension.undertow.HttpListenerService;
import org.wildfly.extension.undertow.ListenerAdd;
import org.wildfly.extension.undertow.ListenerResourceDefinition;
import org.wildfly.extension.undertow.ListenerService;
import org.xnio.OptionMap;

class HttpListenerAdd
extends ListenerAdd<HttpListenerService> {
    HttpListenerAdd() {
    }

    @Override
    HttpListenerService createService(Consumer<ListenerService> serviceConsumer, String name, String serverName, OperationContext context, ModelNode model, OptionMap listenerOptions, OptionMap socketOptions) throws OperationFailedException {
        boolean proxyProtocol = AbstractHttpListenerResourceDefinition.PROXY_PROTOCOL.resolveModelAttribute(context, model).asBoolean();
        boolean certificateForwarding = AbstractHttpListenerResourceDefinition.CERTIFICATE_FORWARDING.resolveModelAttribute(context, model).asBoolean();
        boolean proxyAddressForwarding = AbstractHttpListenerResourceDefinition.PROXY_ADDRESS_FORWARDING.resolveModelAttribute(context, model).asBoolean();
        OptionMap.Builder listenerBuilder = OptionMap.builder().addAll(listenerOptions);
        AbstractHttpListenerResourceDefinition.ENABLE_HTTP2.resolveOption((ExpressionResolver)context, model, listenerBuilder);
        AbstractHttpListenerResourceDefinition.REQUIRE_HOST_HTTP11.resolveOption((ExpressionResolver)context, model, listenerBuilder);
        HttpListenerAdd.handleHttp2Options(context, model, listenerBuilder);
        return new HttpListenerService(serviceConsumer, context.getCurrentAddress(), serverName, listenerBuilder.getMap(), socketOptions, certificateForwarding, proxyAddressForwarding, proxyProtocol);
    }

    static void handleHttp2Options(OperationContext context, ModelNode model, OptionMap.Builder listenerBuilder) throws OperationFailedException {
        AbstractHttpListenerResourceDefinition.HTTP2_ENABLE_PUSH.resolveOption((ExpressionResolver)context, model, listenerBuilder);
        AbstractHttpListenerResourceDefinition.HTTP2_HEADER_TABLE_SIZE.resolveOption((ExpressionResolver)context, model, listenerBuilder);
        AbstractHttpListenerResourceDefinition.HTTP2_INITIAL_WINDOW_SIZE.resolveOption((ExpressionResolver)context, model, listenerBuilder);
        AbstractHttpListenerResourceDefinition.HTTP2_MAX_CONCURRENT_STREAMS.resolveOption((ExpressionResolver)context, model, listenerBuilder);
        AbstractHttpListenerResourceDefinition.HTTP2_MAX_FRAME_SIZE.resolveOption((ExpressionResolver)context, model, listenerBuilder);
        AbstractHttpListenerResourceDefinition.HTTP2_MAX_HEADER_LIST_SIZE.resolveOption((ExpressionResolver)context, model, listenerBuilder);
    }

    @Override
    void configureAdditionalDependencies(OperationContext context, CapabilityServiceBuilder<?> serviceBuilder, ModelNode model, HttpListenerService service) throws OperationFailedException {
        ModelNode redirectBindingRef = ListenerResourceDefinition.REDIRECT_SOCKET.resolveModelAttribute(context, model);
        if (redirectBindingRef.isDefined()) {
            service.getRedirectSocket().set(serviceBuilder.requires(SocketBinding.SERVICE_DESCRIPTOR, redirectBindingRef.asString()));
        }
        service.getHttpListenerRegistry().set(serviceBuilder.requiresCapability("org.wildfly.remoting.http-listener-registry", ListenerRegistry.class, new String[0]));
    }
}

