/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.ListenerRegistry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.undertow.AbstractHttpListenerResourceDefinition;
import org.wildfly.extension.undertow.HttpListenerAdd;
import org.wildfly.extension.undertow.HttpsListenerResourceDefinition;
import org.wildfly.extension.undertow.HttpsListenerService;
import org.wildfly.extension.undertow.ListenerAdd;
import org.wildfly.extension.undertow.ListenerService;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.xnio.OptionMap;

class HttpsListenerAdd
extends ListenerAdd<HttpsListenerService> {
    HttpsListenerAdd() {
    }

    @Override
    HttpsListenerService createService(Consumer<ListenerService> serviceConsumer, String name, String serverName, OperationContext context, ModelNode model, OptionMap listenerOptions, OptionMap socketOptions) throws OperationFailedException {
        OptionMap.Builder builder = OptionMap.builder().addAll(socketOptions);
        ModelNode securityRealmModel = HttpsListenerResourceDefinition.SECURITY_REALM.resolveModelAttribute(context, model);
        boolean proxyProtocol = AbstractHttpListenerResourceDefinition.PROXY_PROTOCOL.resolveModelAttribute(context, model).asBoolean();
        String cipherSuites = null;
        if (securityRealmModel.isDefined()) {
            throw UndertowLogger.ROOT_LOGGER.runtimeSecurityRealmUnsupported();
        }
        OptionMap.Builder listenerBuilder = OptionMap.builder().addAll(listenerOptions);
        AbstractHttpListenerResourceDefinition.ENABLE_HTTP2.resolveOption((ExpressionResolver)context, model, listenerBuilder);
        HttpListenerAdd.handleHttp2Options(context, model, listenerBuilder);
        AbstractHttpListenerResourceDefinition.REQUIRE_HOST_HTTP11.resolveOption((ExpressionResolver)context, model, listenerBuilder);
        boolean certificateForwarding = AbstractHttpListenerResourceDefinition.CERTIFICATE_FORWARDING.resolveModelAttribute(context, model).asBoolean();
        boolean proxyAddressForwarding = AbstractHttpListenerResourceDefinition.PROXY_ADDRESS_FORWARDING.resolveModelAttribute(context, model).asBoolean();
        return new HttpsListenerService(serviceConsumer, context.getCurrentAddress(), serverName, listenerBuilder.getMap(), cipherSuites, builder.getMap(), certificateForwarding, proxyAddressForwarding, proxyProtocol);
    }

    @Override
    void configureAdditionalDependencies(OperationContext context, CapabilityServiceBuilder<?> serviceBuilder, ModelNode model, HttpsListenerService service) throws OperationFailedException {
        service.getHttpListenerRegistry().set(serviceBuilder.requiresCapability("org.wildfly.remoting.http-listener-registry", ListenerRegistry.class, new String[0]));
        ModelNode sslContextModel = HttpsListenerResourceDefinition.SSL_CONTEXT.resolveModelAttribute(context, model);
        String sslContextRef = sslContextModel.isDefined() ? sslContextModel.asString() : null;
        Supplier sslContextInjector = sslContextRef != null ? serviceBuilder.requiresCapability("org.wildfly.security.ssl-context", SSLContext.class, new String[]{sslContextRef}) : null;
        service.setSSLContextSupplier(() -> {
            if (sslContextRef != null) {
                return (SSLContext)sslContextInjector.get();
            }
            try {
                return SSLContext.getDefault();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }
}

