/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.transaction.LockingMode;
import org.wildfly.clustering.cache.CacheProperties;

public class EmbeddedCacheProperties
implements CacheProperties {
    private final boolean lockOnRead;
    private final boolean lockOnWrite;
    private final boolean marshalling;
    private final boolean persistent;
    private final boolean transactional;

    public EmbeddedCacheProperties(Cache<?, ?> cache) {
        this(cache.getCacheConfiguration());
    }

    public EmbeddedCacheProperties(Configuration configuration) {
        this.transactional = configuration.transaction().transactionMode().isTransactional();
        this.lockOnWrite = this.transactional && configuration.transaction().lockingMode() == LockingMode.PESSIMISTIC;
        this.lockOnRead = this.lockOnWrite && configuration.locking().lockIsolationLevel() == IsolationLevel.REPEATABLE_READ;
        boolean clustered = configuration.clustering().cacheMode().needsStateTransfer();
        boolean hasStore = configuration.persistence().usingStores();
        this.marshalling = clustered || hasStore;
        this.persistent = clustered || hasStore && !configuration.persistence().passivation() || configuration.memory().isOffHeap();
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public boolean isLockOnRead() {
        return this.lockOnRead;
    }

    public boolean isLockOnWrite() {
        return this.lockOnWrite;
    }

    public boolean isMarshalling() {
        return this.marshalling;
    }
}

