/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.docvalues.impl;

import java.io.IOException;
import java.util.function.LongToDoubleFunction;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.NumericUtils;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.NumericDoubleValues;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.SingletonNumericDoubleDocValues;

public abstract class SortedNumericDoubleDocValues
extends DocIdSetIterator {
    protected SortedNumericDoubleDocValues() {
    }

    public abstract boolean advanceExact(int var1) throws IOException;

    public abstract double nextValue() throws IOException;

    public abstract int docValueCount();

    public static SortedNumericDoubleDocValues fromDoubleField(SortedNumericDocValues values) {
        return SortedNumericDoubleDocValues.create(values, NumericUtils::sortableLongToDouble);
    }

    public static SortedNumericDoubleDocValues fromFloatField(SortedNumericDocValues values) {
        return SortedNumericDoubleDocValues.create(values, v -> NumericUtils.sortableIntToFloat((int)((int)v)));
    }

    public static NumericDoubleValues unwrapSingleton(SortedNumericDoubleDocValues values) {
        if (values instanceof SingleValuedFieldNumericDoubleDocValues) {
            return ((SingleValuedFieldNumericDoubleDocValues)values).toNumericDoubleValues();
        }
        return null;
    }

    public static SortedNumericDoubleDocValues create(SortedNumericDocValues values, LongToDoubleFunction decoder) {
        NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)values);
        if (singleton != null) {
            return new SingleValuedFieldNumericDoubleDocValues(singleton, decoder);
        }
        return new MultiValuedFieldNumericDoubleDocValues(values, decoder);
    }

    private static class SingleValuedFieldNumericDoubleDocValues
    extends SingletonNumericDoubleDocValues {
        private final LongToDoubleFunction decoder;

        SingleValuedFieldNumericDoubleDocValues(NumericDocValues values, LongToDoubleFunction decoder) {
            super(values);
            this.decoder = decoder;
        }

        @Override
        public NumericDoubleValues toNumericDoubleValues() {
            return NumericDoubleValues.fromField(this.values, this.decoder);
        }

        @Override
        public double nextValue() throws IOException {
            return this.decoder.applyAsDouble(this.values.longValue());
        }
    }

    private static class MultiValuedFieldNumericDoubleDocValues
    extends SortedNumericDoubleDocValues {
        private final SortedNumericDocValues values;
        private final LongToDoubleFunction decoder;

        MultiValuedFieldNumericDoubleDocValues(SortedNumericDocValues values, LongToDoubleFunction decoder) {
            this.values = values;
            this.decoder = decoder;
        }

        @Override
        public double nextValue() throws IOException {
            return this.decoder.applyAsDouble(this.values.nextValue());
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            return this.values.advanceExact(doc);
        }

        public int advance(int target) throws IOException {
            return this.values.advance(target);
        }

        public int nextDoc() throws IOException {
            return this.values.nextDoc();
        }

        public int docID() {
            return this.values.docID();
        }

        @Override
        public int docValueCount() {
            return this.values.docValueCount();
        }

        public long cost() {
            return this.values.cost();
        }
    }
}

