/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Explanation;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneSearchIndexScopeImpl;
import org.hibernate.search.backend.lucene.search.projection.dsl.DocumentTree;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneByMappedTypeProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneCompositeProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneConstantProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneDocumentProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneDocumentReferenceProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneDocumentTreeProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneEntityCompositeProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneEntityLoadingProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneEntityReferenceProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneExplanationProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneIdProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneScoreProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneThrowingProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneWithParametersProjection;
import org.hibernate.search.engine.backend.common.DocumentReference;
import org.hibernate.search.engine.search.common.NamedValues;
import org.hibernate.search.engine.search.common.spi.SearchIndexIdentifierContext;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.dsl.ProjectionFinalStep;
import org.hibernate.search.engine.search.projection.spi.CompositeProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.SearchProjectionBuilderFactory;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.reporting.spi.EventContextProvider;

public class LuceneSearchProjectionBuilderFactory
implements SearchProjectionBuilderFactory {
    private final LuceneSearchIndexScopeImpl scope;

    public LuceneSearchProjectionBuilderFactory(LuceneSearchIndexScopeImpl scope) {
        this.scope = scope;
    }

    public SearchProjection<DocumentReference> documentReference() {
        return new LuceneDocumentReferenceProjection(this.scope);
    }

    public <E> SearchProjection<E> entityLoading() {
        return new LuceneEntityLoadingProjection(this.scope);
    }

    public <R> SearchProjection<R> entityReference() {
        return new LuceneEntityReferenceProjection(this.scope);
    }

    public <I> SearchProjection<I> id(Class<I> requestedIdentifierType) {
        SearchIndexIdentifierContext identifier = this.scope.identifier();
        return new LuceneIdProjection(this.scope, identifier.mappingProjectionConverter().withConvertedType(requestedIdentifierType, (EventContextProvider)identifier));
    }

    public SearchProjection<Float> score() {
        return new LuceneScoreProjection(this.scope);
    }

    public CompositeProjectionBuilder composite() {
        return new LuceneCompositeProjection.Builder(this.scope);
    }

    public <T> SearchProjection<T> constant(T value) {
        return new LuceneConstantProjection<T>(this.scope, value);
    }

    public <T> SearchProjection<T> entityComposite(SearchProjection<T> delegate) {
        return new LuceneEntityCompositeProjection<T>(this.scope, LuceneSearchProjection.from(this.scope, delegate));
    }

    public <T> SearchProjection<T> throwing(Supplier<SearchException> exceptionSupplier) {
        return new LuceneThrowingProjection(this.scope, exceptionSupplier);
    }

    public <T> SearchProjection<T> byTypeName(Map<String, ? extends SearchProjection<? extends T>> inners) {
        HashMap luceneInners = new HashMap();
        for (Map.Entry<String, SearchProjection<T>> entry : inners.entrySet()) {
            luceneInners.put(entry.getKey(), LuceneSearchProjection.from(this.scope, entry.getValue()));
        }
        return new LuceneByMappedTypeProjection(this.scope, luceneInners);
    }

    public <T> SearchProjection<T> withParameters(Function<? super NamedValues, ? extends ProjectionFinalStep<T>> projectionCreator) {
        return new LuceneWithParametersProjection(this.scope, projectionCreator);
    }

    public SearchProjection<Document> document() {
        return new LuceneDocumentProjection(this.scope);
    }

    public SearchProjection<Explanation> explanation() {
        return new LuceneExplanationProjection(this.scope);
    }

    public SearchProjection<DocumentTree> documentTree() {
        return new LuceneDocumentTreeProjection(this.scope);
    }
}

