/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.function.Function;
import org.wildfly.clustering.function.BiConsumer;
import org.wildfly.clustering.function.BooleanSupplier;
import org.wildfly.clustering.function.Predicate;

public interface BiPredicate<T, U>
extends java.util.function.BiPredicate<T, U> {
    public static final BiPredicate<?, ?> ALWAYS = BiPredicate.of(BiConsumer.EMPTY, BooleanSupplier.TRUE);
    public static final BiPredicate<?, ?> NEVER = BiPredicate.of(BiConsumer.EMPTY, BooleanSupplier.FALSE);

    @Override
    default public BiPredicate<T, U> and(final java.util.function.BiPredicate<? super T, ? super U> other) {
        return new BiPredicate<T, U>(){

            @Override
            public boolean test(T value1, U value2) {
                return BiPredicate.this.test(value1, value2) && other.test(value1, value2);
            }
        };
    }

    @Override
    default public BiPredicate<T, U> negate() {
        return new BiPredicate<T, U>(){

            @Override
            public boolean test(T value1, U value2) {
                return !BiPredicate.this.test(value1, value2);
            }
        };
    }

    @Override
    default public BiPredicate<T, U> or(final java.util.function.BiPredicate<? super T, ? super U> other) {
        return new BiPredicate<T, U>(){

            @Override
            public boolean test(T value1, U value2) {
                return BiPredicate.this.test(value1, value2) || other.test(value1, value2);
            }
        };
    }

    default public BiPredicate<T, U> xor(final java.util.function.BiPredicate<? super T, ? super U> other) {
        return new BiPredicate<T, U>(){

            @Override
            public boolean test(T value1, U value2) {
                return BiPredicate.this.test(value1, value2) ^ other.test(value1, value2);
            }
        };
    }

    default public BiPredicate<U, T> reverse() {
        return new BiPredicate<U, T>(){

            @Override
            public boolean test(U value2, T value1) {
                return BiPredicate.this.test(value1, value2);
            }
        };
    }

    default public <V1, V2> BiPredicate<V1, V2> compose(final Function<? super V1, ? extends T> before1, final Function<? super V2, ? extends U> before2) {
        return new BiPredicate<V1, V2>(){

            @Override
            public boolean test(V1 value1, V2 value2) {
                return BiPredicate.this.test(before1.apply(value1), before2.apply(value2));
            }
        };
    }

    default public <V> Predicate<V> composeUnary(final Function<? super V, ? extends T> before1, final Function<? super V, ? extends U> before2) {
        return new Predicate<V>(){

            @Override
            public boolean test(V value) {
                return BiPredicate.this.test(before1.apply(value), before2.apply(value));
            }
        };
    }

    public static <T, U> BiPredicate<T, U> always() {
        return ALWAYS;
    }

    public static <T, U> BiPredicate<T, U> never() {
        return NEVER;
    }

    public static <T, U> BiPredicate<T, U> of(boolean value) {
        return value ? BiPredicate.always() : BiPredicate.never();
    }

    public static <T, U> BiPredicate<T, U> of(final java.util.function.BiConsumer<T, U> consumer, final java.util.function.BooleanSupplier supplier) {
        return new BiPredicate<T, U>(){

            @Override
            public boolean test(T value1, U value2) {
                consumer.accept(value1, value2);
                return supplier.getAsBoolean();
            }
        };
    }

    public static <T, U> BiPredicate<T, U> testFormer(java.util.function.Predicate<T> predicate) {
        return BiPredicate.and(predicate, Predicate.always());
    }

    public static <T, U> BiPredicate<T, U> testLatter(java.util.function.Predicate<U> predicate) {
        return BiPredicate.and(Predicate.always(), predicate);
    }

    public static <T, U> BiPredicate<T, U> and(final java.util.function.Predicate<T> predicate1, final java.util.function.Predicate<U> predicate2) {
        return new BiPredicate<T, U>(){

            @Override
            public boolean test(T value1, U value2) {
                return predicate1.test(value1) && predicate2.test(value2);
            }
        };
    }

    public static <T, U> BiPredicate<T, U> or(final java.util.function.Predicate<T> predicate1, final java.util.function.Predicate<U> predicate2) {
        return new BiPredicate<T, U>(){

            @Override
            public boolean test(T value1, U value2) {
                return predicate1.test(value1) || predicate2.test(value2);
            }
        };
    }

    public static <T, U> BiPredicate<T, U> xor(final java.util.function.Predicate<T> predicate1, final java.util.function.Predicate<U> predicate2) {
        return new BiPredicate<T, U>(){

            @Override
            public boolean test(T value1, U value2) {
                return predicate1.test(value1) ^ predicate2.test(value2);
            }
        };
    }
}

