/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongSupplier;
import java.util.function.LongUnaryOperator;
import java.util.function.Supplier;
import java.util.function.ToLongBiFunction;
import java.util.function.ToLongFunction;
import org.wildfly.clustering.function.BiConsumer;
import org.wildfly.clustering.function.Consumer;

public interface LongConsumer
extends java.util.function.LongConsumer {
    public static final LongConsumer EMPTY = value -> {};

    @Override
    default public LongConsumer andThen(final java.util.function.LongConsumer after) {
        return new LongConsumer(){

            @Override
            public void accept(long value) {
                LongConsumer.this.accept(value);
                after.accept(value);
            }
        };
    }

    default public Consumer<Long> boxed() {
        return this.compose(Long::longValue);
    }

    default public LongConsumer when(final LongPredicate predicate) {
        return new LongConsumer(){

            @Override
            public void accept(long value) {
                if (predicate.test(value)) {
                    LongConsumer.this.accept(value);
                }
            }
        };
    }

    default public LongConsumer withDefault(final LongPredicate predicate, final LongSupplier defaultValue) {
        return new LongConsumer(){

            @Override
            public void accept(long value) {
                LongConsumer.this.accept(predicate.test(value) ? value : defaultValue.getAsLong());
            }
        };
    }

    default public LongConsumer composeAsLong(final LongUnaryOperator composer) {
        return new LongConsumer(){

            @Override
            public void accept(long value) {
                LongConsumer.this.accept(composer.applyAsLong(value));
            }
        };
    }

    default public <V> Consumer<V> compose(final ToLongFunction<V> composer) {
        return new Consumer<V>(){

            @Override
            public void accept(V value) {
                LongConsumer.this.accept(composer.applyAsLong(value));
            }
        };
    }

    default public <V1, V2> BiConsumer<V1, V2> compose(final ToLongBiFunction<V1, V2> composer) {
        return new BiConsumer<V1, V2>(){

            @Override
            public void accept(V1 value1, V2 value2) {
                LongConsumer.this.accept(composer.applyAsLong(value1, value2));
            }
        };
    }

    default public <R> LongFunction<R> thenReturn(final Supplier<R> factory) {
        return new LongFunction<R>(){

            @Override
            public R apply(long value) {
                LongConsumer.this.accept(value);
                return factory.get();
            }
        };
    }

    default public LongUnaryOperator thenReturnLong(final LongSupplier factory) {
        return new LongUnaryOperator(){

            @Override
            public long applyAsLong(long value) {
                LongConsumer.this.accept(value);
                return factory.getAsLong();
            }
        };
    }

    public static LongConsumer acceptAll(final Iterable<? extends LongConsumer> consumers) {
        return new LongConsumer(){

            @Override
            public void accept(long value) {
                for (LongConsumer consumer : consumers) {
                    consumer.accept(value);
                }
            }
        };
    }
}

