/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.AbstractMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.function.Function;
import org.wildfly.clustering.function.Supplier;

public interface UnaryOperator<T>
extends java.util.function.UnaryOperator<T>,
Function<T, T> {
    public static final UnaryOperator<?> IDENTITY = value -> value;
    public static final UnaryOperator<?> NULL = UnaryOperator.of(Consumer.empty(), Supplier.empty());

    default public UnaryOperator<T> orDefault(final Predicate<T> predicate, final java.util.function.Supplier<T> defaultResult) {
        return new UnaryOperator<T>(){

            @Override
            public T apply(T value) {
                return predicate.test(value) ? UnaryOperator.this.apply(value) : defaultResult.get();
            }
        };
    }

    default public UnaryOperator<T> withDefault(final Predicate<T> predicate, final java.util.function.Supplier<T> defaultValue) {
        return new UnaryOperator<T>(){

            @Override
            public T apply(T value) {
                return UnaryOperator.this.apply(predicate.test(value) ? value : defaultValue.get());
            }
        };
    }

    default public UnaryOperator<T> andThen(final java.util.function.UnaryOperator<T> operator) {
        return new UnaryOperator<T>(){

            @Override
            public T apply(T value) {
                return operator.apply(UnaryOperator.this.apply(value));
            }
        };
    }

    default public UnaryOperator<T> compose(final java.util.function.UnaryOperator<T> operator) {
        return new UnaryOperator<T>(){

            @Override
            public T apply(T value) {
                return UnaryOperator.this.apply(operator.apply(value));
            }
        };
    }

    default public UnaryOperator<T> handle(final BiFunction<T, RuntimeException, T> handler) {
        return new UnaryOperator<T>(){

            @Override
            public T apply(T value) {
                try {
                    return UnaryOperator.this.apply(value);
                }
                catch (RuntimeException e) {
                    return handler.apply(value, e);
                }
            }
        };
    }

    public static <T> UnaryOperator<T> identity() {
        return IDENTITY;
    }

    public static <T> UnaryOperator<T> empty() {
        return NULL;
    }

    public static <T> UnaryOperator<T> of(T value) {
        return value != null ? UnaryOperator.of(Consumer.empty(), Supplier.of(value)) : UnaryOperator.empty();
    }

    public static <T> UnaryOperator<T> of(final java.util.function.Consumer<T> consumer, final java.util.function.Supplier<T> supplier) {
        return new UnaryOperator<T>(){

            @Override
            public T apply(T value) {
                consumer.accept(value);
                return supplier.get();
            }
        };
    }

    public static <T> UnaryOperator<T> apply(final java.util.function.Function<? super T, T> function) {
        return function != null && function != Function.NULL ? new UnaryOperator<T>(){

            @Override
            public T apply(T value) {
                return function.apply(value);
            }
        } : UnaryOperator.empty();
    }

    public static <K, V> UnaryOperator<Map.Entry<K, V>> entry(final UnaryOperator<K> keyFunction, final UnaryOperator<V> valueFunction) {
        return new UnaryOperator<Map.Entry<K, V>>(){

            @Override
            public Map.Entry<K, V> apply(Map.Entry<K, V> entry) {
                return new AbstractMap.SimpleImmutableEntry(keyFunction.apply(entry.getKey()), valueFunction.apply(entry.getValue()));
            }
        };
    }
}

