/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.server.Group;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.server.service.ClusteringServiceDescriptor;
import org.wildfly.clustering.server.service.LocalCacheServiceInstallerProvider;
import org.wildfly.clustering.singleton.Singleton;
import org.wildfly.clustering.singleton.SingletonServiceBuilderFactory;
import org.wildfly.clustering.singleton.compat.SingletonServiceBuilder;
import org.wildfly.clustering.singleton.compat.SingletonServiceConfigurator;
import org.wildfly.clustering.singleton.compat.SingletonServiceTargetFactory;
import org.wildfly.clustering.singleton.election.SingletonElectionListener;
import org.wildfly.clustering.singleton.election.SingletonElectionPolicy;
import org.wildfly.clustering.singleton.server.LocalSingletonServiceTarget;
import org.wildfly.clustering.singleton.service.SingletonServiceConfiguratorFactory;
import org.wildfly.clustering.singleton.service.SingletonServiceTarget;
import org.wildfly.common.function.Functions;
import org.wildfly.service.ServiceDependency;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ServiceInstaller;

public class LocalSingletonServiceTargetFactoryServiceInstallerProvider
implements LocalCacheServiceInstallerProvider {
    public Iterable<ServiceInstaller> apply(BinaryServiceConfiguration configuration) {
        final ServiceDependency member = ServiceDependency.on((ServiceName)ServiceNameFactory.resolveServiceName((UnaryServiceDescriptor)ClusteringServiceDescriptor.GROUP, (String)"local")).map(Group::getLocalMember);
        final Function discardingStateProviderFactory = new Function<ServiceBuilder<?>, Consumer<Singleton>>(){

            @Override
            public Consumer<Singleton> apply(ServiceBuilder<?> builder) {
                return Functions.discardingConsumer();
            }
        };
        SingletonServiceTargetFactory factory = new SingletonServiceTargetFactory(){

            public SingletonServiceTarget createSingletonServiceTarget(ServiceTarget target) {
                return new LocalSingletonServiceTarget(target, member, discardingStateProviderFactory);
            }

            public SingletonServiceConfigurator createSingletonServiceConfigurator(final ServiceName name) {
                final Function singletonFactory = new Function<ServiceBuilder<?>, Consumer<Singleton>>(){

                    @Override
                    public Consumer<Singleton> apply(ServiceBuilder<?> builder) {
                        return builder.provides(new ServiceName[]{name.append(new String[]{"singleton"})});
                    }
                };
                return new SingletonServiceConfigurator(){
                    private SingletonElectionListener listener = null;

                    public ServiceName getServiceName() {
                        return name;
                    }

                    public org.wildfly.clustering.singleton.service.SingletonServiceBuilder<?> build(ServiceTarget target) {
                        return new LocalSingletonServiceTarget(target, member, singletonFactory).addService(name).withElectionListener(this.listener);
                    }

                    public SingletonServiceConfigurator withElectionPolicy(SingletonElectionPolicy policy) {
                        return this;
                    }

                    public SingletonServiceConfigurator withElectionListener(SingletonElectionListener listener) {
                        this.listener = listener;
                        return this;
                    }

                    public SingletonServiceConfigurator requireQuorum(int quorum) {
                        return this;
                    }
                };
            }

            public <T> SingletonServiceBuilder<T> createSingletonServiceBuilder(final ServiceName name, final Service<T> service) {
                return new SingletonServiceBuilder<T>(){
                    private SingletonElectionListener listener = null;

                    public ServiceName getServiceName() {
                        return name;
                    }

                    public org.wildfly.clustering.singleton.service.SingletonServiceBuilder<T> build(ServiceTarget target) {
                        return new LocalSingletonServiceTarget(target, member, discardingStateProviderFactory).addService(name, service).withElectionListener(this.listener);
                    }

                    public SingletonServiceBuilder<T> withElectionPolicy(SingletonElectionPolicy policy) {
                        return this;
                    }

                    public SingletonServiceBuilder<T> withElectionListener(SingletonElectionListener listener) {
                        this.listener = listener;
                        return this;
                    }

                    public SingletonServiceBuilder<T> requireQuorum(int quorum) {
                        return this;
                    }
                };
            }

            public <T> SingletonServiceBuilder<T> createSingletonServiceBuilder(ServiceName name, Service<T> primaryService, Service<T> backupService) {
                return this.createSingletonServiceBuilder(name, primaryService);
            }
        };
        return List.of((ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Object)factory).provides(configuration.resolveServiceName(org.wildfly.clustering.singleton.service.SingletonServiceTargetFactory.SERVICE_DESCRIPTOR))).provides(configuration.resolveServiceName(SingletonServiceConfiguratorFactory.SERVICE_DESCRIPTOR))).provides(configuration.resolveServiceName(SingletonServiceBuilderFactory.SERVICE_DESCRIPTOR))).build());
    }
}

