/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.scheduler;

import java.util.Optional;
import java.util.function.Function;
import org.wildfly.clustering.server.scheduler.Scheduler;
import org.wildfly.clustering.server.service.Service;

public interface SchedulerService<K, V>
extends Scheduler<K, V>,
Service,
AutoCloseable {
    default public <KK, VV> SchedulerService<KK, VV> compose(final Function<KK, K> identifierMapper, final Function<VV, Optional<V>> entryMapper) {
        return new SchedulerService<KK, VV>(){

            @Override
            public void schedule(KK id, VV value) {
                Optional mapped = (Optional)entryMapper.apply(value);
                if (mapped.isPresent()) {
                    SchedulerService.this.schedule(identifierMapper.apply(id), mapped.get());
                }
            }

            @Override
            public void cancel(KK id) {
                SchedulerService.this.cancel(identifierMapper.apply(id));
            }

            @Override
            public boolean contains(KK id) {
                return SchedulerService.this.contains(identifierMapper.apply(id));
            }

            @Override
            public boolean isStarted() {
                return SchedulerService.this.isStarted();
            }

            @Override
            public void start() {
                SchedulerService.this.start();
            }

            @Override
            public void stop() {
                SchedulerService.this.stop();
            }

            @Override
            public void close() {
                SchedulerService.this.close();
            }
        };
    }

    @Override
    public void close();
}

