/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.xsite;

import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.BackupSender;

public class BaseBackupInterceptor
extends CommandInterceptor {
    protected BackupSender backupSender;
    protected TransactionTable txTable;
    private static final Log log = LogFactory.getLog(BaseBackupInterceptor.class);

    @Inject
    void init(BackupSender sender, TransactionTable txTable) {
        this.backupSender = sender;
        this.txTable = txTable;
    }

    protected boolean isTxFromRemoteSite(GlobalTransaction gtx) {
        LocalTransaction remoteTx = this.txTable.getLocalTransaction(gtx);
        return remoteTx != null && remoteTx.isFromRemoteSite();
    }

    protected boolean shouldInvokeRemoteTxCommand(TxInvocationContext ctx) {
        boolean shouldBackupRemotely = ctx.isOriginLocal() && ctx.hasModifications();
        this.getLog().tracef("Should backup remotely? %s", shouldBackupRemotely);
        return shouldBackupRemotely;
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

