/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.util.Properties;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.jmx.JmxDomainConflictException;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class JmxUtil {
    private static final Log log = LogFactory.getLog(JmxUtil.class);

    public static MBeanServer lookupMBeanServer(GlobalConfiguration cfg) {
        MBeanServerLookup lookup = cfg.globalJmxStatistics().mbeanServerLookup();
        return lookup.getMBeanServer((Properties)cfg.globalJmxStatistics().properties());
    }

    public static String buildJmxDomain(GlobalConfiguration cfg, MBeanServer mBeanServer, String groupName) {
        String configJmxDomain;
        String jmxDomain = JmxUtil.findJmxDomain(cfg.globalJmxStatistics().domain(), mBeanServer, groupName);
        if (!jmxDomain.equals(configJmxDomain = cfg.globalJmxStatistics().domain()) && !cfg.globalJmxStatistics().allowDuplicateDomains()) {
            log.cacheManagerAlreadyRegistered(configJmxDomain);
            throw new JmxDomainConflictException(String.format("Domain already registered %s when trying to register: %s", configJmxDomain, groupName));
        }
        return jmxDomain;
    }

    public static void registerMBean(Object mbean, ObjectName objectName, MBeanServer mBeanServer) throws Exception {
        if (!mBeanServer.isRegistered(objectName)) {
            try {
                mBeanServer.registerMBean(mbean, objectName);
                log.tracef("Registered %s under %s", mbean, objectName);
            }
            catch (InstanceAlreadyExistsException e) {
                log.couldNotRegisterObjectName(objectName, e);
            }
        } else {
            log.debugf("Object name %s already registered", objectName);
        }
    }

    public static void unregisterMBean(ObjectName objectName, MBeanServer mBeanServer) throws Exception {
        if (mBeanServer.isRegistered(objectName)) {
            mBeanServer.unregisterMBean(objectName);
            log.tracef("Unregistered %s", objectName);
        }
    }

    public static int unregisterMBeans(String filter, MBeanServer mBeanServer) {
        try {
            ObjectName filterObjName = new ObjectName(filter);
            Set<ObjectInstance> mbeans = mBeanServer.queryMBeans(filterObjName, null);
            for (ObjectInstance mbean : mbeans) {
                ObjectName name = mbean.getObjectName();
                if (log.isTraceEnabled()) {
                    log.trace("Unregistering mbean with name: " + name);
                }
                mBeanServer.unregisterMBean(name);
            }
            return mbeans.size();
        }
        catch (Exception e) {
            throw new CacheException("Unable to register mbeans with filter=" + filter, (Throwable)e);
        }
    }

    private static String findJmxDomain(String jmxDomain, MBeanServer mBeanServer, String groupName) {
        int index = 2;
        String finalName = jmxDomain;
        boolean done = false;
        while (!done) {
            done = true;
            try {
                ObjectName targetName = new ObjectName(finalName + ':' + groupName + ",*");
                if (mBeanServer.queryNames(targetName, null).size() <= 0) continue;
                finalName = jmxDomain + index++;
                done = false;
            }
            catch (MalformedObjectNameException e) {
                throw new CacheException("Unable to check for duplicate names", (Throwable)e);
            }
        }
        return finalName;
    }
}

