/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import javax.ejb.EJBException;
import javax.ejb.ScheduleExpression;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.TimerServiceRegistry;
import org.jboss.as.ejb3.component.allowedmethods.AllowedMethodsInformation;
import org.jboss.as.ejb3.component.allowedmethods.MethodType;
import org.jboss.as.ejb3.component.singleton.SingletonComponent;
import org.jboss.as.ejb3.context.CurrentInvocationContext;
import org.jboss.invocation.InterceptorContext;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class NonFunctionalTimerService
implements TimerService,
Service<TimerService> {
    public static final NonFunctionalTimerService DISABLED = new NonFunctionalTimerService(EjbMessages.MESSAGES.timerServiceIsNotActive(), null);
    private final String message;
    private final TimerServiceRegistry timerServiceRegistry;

    public NonFunctionalTimerService(String message, TimerServiceRegistry timerServiceRegistry) {
        this.message = message;
        this.timerServiceRegistry = timerServiceRegistry;
    }

    public static ServiceName serviceNameFor(EJBComponentDescription ejbComponentDescription) {
        if (ejbComponentDescription == null || ejbComponentDescription.getServiceName() == null) {
            return null;
        }
        return ejbComponentDescription.getServiceName().append(new String[]{"ejb", "non-functional-timerservice"});
    }

    public Timer createCalendarTimer(ScheduleExpression schedule) throws IllegalArgumentException, IllegalStateException, EJBException {
        throw new IllegalStateException(this.message);
    }

    public Timer createCalendarTimer(ScheduleExpression schedule, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        throw new IllegalStateException(this.message);
    }

    public Timer createIntervalTimer(Date initialExpiration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        throw new IllegalStateException(this.message);
    }

    public Timer createIntervalTimer(long initialDuration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        throw new IllegalStateException(this.message);
    }

    public Timer createSingleActionTimer(Date expiration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        throw new IllegalStateException(this.message);
    }

    public Timer createSingleActionTimer(long duration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        throw new IllegalStateException(this.message);
    }

    public Timer createTimer(long duration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        throw new IllegalStateException(this.message);
    }

    public Timer createTimer(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        throw new IllegalStateException(this.message);
    }

    public Timer createTimer(Date expiration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        throw new IllegalStateException(this.message);
    }

    public Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        throw new IllegalStateException(this.message);
    }

    public Collection<Timer> getTimers() throws IllegalStateException, EJBException {
        this.assertInvocationAllowed();
        return Collections.emptySet();
    }

    public Collection<Timer> getAllTimers() throws IllegalStateException, EJBException {
        if (this.timerServiceRegistry != null) {
            return this.timerServiceRegistry.getAllActiveTimers();
        }
        return this.getTimers();
    }

    private void assertInvocationAllowed() {
        Component component;
        AllowedMethodsInformation.checkAllowed(MethodType.TIMER_SERVICE_METHOD);
        InterceptorContext currentInvocationContext = CurrentInvocationContext.get();
        if (currentInvocationContext == null) {
            return;
        }
        Method invokedMethod = currentInvocationContext.getMethod();
        if (invokedMethod == null && !((component = (Component)currentInvocationContext.getPrivateData(Component.class)) instanceof SingletonComponent)) {
            throw EjbMessages.MESSAGES.failToInvokeTimerServiceDoLifecycle();
        }
    }

    public void start(StartContext startContext) throws StartException {
        if (this.timerServiceRegistry != null) {
            this.timerServiceRegistry.registerTimerService(this);
        }
    }

    public void stop(StopContext stopContext) {
        if (this.timerServiceRegistry != null) {
            this.timerServiceRegistry.unRegisterTimerService(this);
        }
    }

    public TimerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

