/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx.model;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.notification.Notification;
import org.jboss.as.controller.notification.NotificationHandler;
import org.jboss.as.controller.registry.NotificationHandlerRegistration;
import org.jboss.as.jmx.BaseMBeanServerPlugin;
import org.jboss.as.jmx.JmxMessages;
import org.jboss.as.jmx.model.ConfiguredDomains;
import org.jboss.as.jmx.model.ModelControllerMBeanHelper;
import org.jboss.as.jmx.model.NameConverter;
import org.jboss.as.jmx.model.ObjectNameAddressUtil;
import org.jboss.as.jmx.model.SecurityActions;
import org.jboss.as.jmx.model.TypeConverters;
import org.jboss.dmr.ModelNode;

public class ModelControllerMBeanServerPlugin
extends BaseMBeanServerPlugin {
    private final ConfiguredDomains configuredDomains;
    private final ModelControllerMBeanHelper legacyHelper;
    private final ModelControllerMBeanHelper exprHelper;
    private final NotificationHandlerRegistration notificationRegistry;
    private final AtomicLong notificationSequenceNumber = new AtomicLong(0L);

    public ModelControllerMBeanServerPlugin(ConfiguredDomains configuredDomains, ModelController controller, MBeanServerDelegate delegate, boolean legacyWithProperPropertyFormat, boolean forStandalone) {
        assert (configuredDomains != null);
        this.configuredDomains = configuredDomains;
        this.notificationRegistry = controller.getNotificationRegistry();
        this.legacyHelper = configuredDomains.getLegacyDomain() != null ? new ModelControllerMBeanHelper(TypeConverters.createLegacyTypeConverters(legacyWithProperPropertyFormat), configuredDomains, configuredDomains.getLegacyDomain(), controller, forStandalone) : null;
        ModelControllerMBeanHelper modelControllerMBeanHelper = this.exprHelper = configuredDomains.getExprDomain() != null ? new ModelControllerMBeanHelper(TypeConverters.createExpressionTypeConverters(), configuredDomains, configuredDomains.getExprDomain(), controller, forStandalone) : null;
        if (delegate != null) {
            for (String domain : configuredDomains.getDomains()) {
                ResourceRegistrationNotificationHandler handler = new ResourceRegistrationNotificationHandler(delegate, domain);
                this.notificationRegistry.registerNotificationHandler(NotificationHandlerRegistration.ANY_ADDRESS, (NotificationHandler)handler, (org.jboss.as.controller.notification.NotificationFilter)handler);
            }
        }
    }

    public boolean accepts(ObjectName objectName) {
        String domain = objectName.getDomain();
        if (!objectName.isDomainPattern()) {
            return domain.equals(this.configuredDomains.getLegacyDomain()) || domain.equals(this.configuredDomains.getExprDomain());
        }
        Pattern p = Pattern.compile(objectName.getDomain().replace("*", ".*"));
        return p.matcher(this.configuredDomains.getLegacyDomain()).matches() || p.matcher(this.configuredDomains.getExprDomain()).matches();
    }

    public boolean shouldAuditLog() {
        return false;
    }

    public boolean shouldAuthorize() {
        return false;
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        return this.getHelper(name).getAttribute(name, attribute);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        return this.getHelper(name).getAttributes(name, attributes);
    }

    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        if (this.getHelper(loaderName).resolvePathAddress(loaderName) != null) {
            return SecurityActions.getClassLoader(this.getClass());
        }
        throw JmxMessages.MESSAGES.mbeanNotFound(loaderName);
    }

    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        if (this.getHelper(mbeanName).toPathAddress(mbeanName) != null) {
            return SecurityActions.getClassLoader(this.getClass());
        }
        throw JmxMessages.MESSAGES.mbeanNotFound(mbeanName);
    }

    public String[] getDomains() {
        return this.configuredDomains.getDomains();
    }

    public Integer getMBeanCount() {
        int count = 0;
        if (this.legacyHelper != null) {
            count += this.legacyHelper.getMBeanCount();
        }
        if (this.exprHelper != null) {
            count += this.exprHelper.getMBeanCount();
        }
        return count;
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.getHelper(name).getMBeanInfo(name);
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        return this.getHelper(name).getObjectInstance(name);
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.getHelper(name).invoke(name, operationName, params, signature);
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        return NotificationBroadcaster.class.getName().equals(className);
    }

    public boolean isRegistered(ObjectName name) {
        return this.getHelper(name).resolvePathAddress(name) != null;
    }

    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        if (name != null && !name.isDomainPattern()) {
            return this.getHelper(name).queryMBeans(name, query);
        }
        HashSet<ObjectInstance> instances = new HashSet<ObjectInstance>();
        if (this.legacyHelper != null) {
            instances.addAll(this.legacyHelper.queryMBeans(name, query));
        }
        if (this.exprHelper != null) {
            instances.addAll(this.exprHelper.queryMBeans(name, query));
        }
        return instances;
    }

    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        if (name != null && !name.isDomainPattern()) {
            return this.getHelper(name).queryNames(name, query);
        }
        HashSet<ObjectName> instances = new HashSet<ObjectName>();
        if (this.legacyHelper != null) {
            instances.addAll(this.legacyHelper.queryNames(name, query));
        }
        if (this.exprHelper != null) {
            instances.addAll(this.exprHelper.queryNames(name, query));
        }
        return instances;
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.getHelper(name).setAttribute(name, attribute);
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        return this.getHelper(name).setAttributes(name, attributes);
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        PathAddress pathAddress = this.getHelper(name).toPathAddress(name);
        JMXNotificationHandler handler = new JMXNotificationHandler(this.getHelper(name).getDomain(), name, listener, filter, handback);
        this.notificationRegistry.registerNotificationHandler(pathAddress, (NotificationHandler)handler, (org.jboss.as.controller.notification.NotificationFilter)handler);
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        throw new RuntimeOperationsException(JmxMessages.MESSAGES.addNotificationListerWithObjectNameNotSupported(listener));
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        PathAddress pathAddress = this.getHelper(name).toPathAddress(name);
        JMXNotificationHandler handler = new JMXNotificationHandler(this.getHelper(name).getDomain(), name, listener, filter, handback);
        this.notificationRegistry.unregisterNotificationHandler(pathAddress, (NotificationHandler)handler, (org.jboss.as.controller.notification.NotificationFilter)handler);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.removeNotificationListener(name, listener, null, null);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        throw new RuntimeOperationsException(JmxMessages.MESSAGES.removeNotificationListerWithObjectNameNotSupported(listener));
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        throw new RuntimeOperationsException(JmxMessages.MESSAGES.removeNotificationListerWithObjectNameNotSupported(listener));
    }

    private ModelControllerMBeanHelper getHelper(ObjectName name) {
        String domain = name.getDomain();
        if (domain.equals(this.configuredDomains.getLegacyDomain()) || name.isDomainPattern()) {
            return this.legacyHelper;
        }
        if (domain.equals(this.configuredDomains.getExprDomain())) {
            return this.exprHelper;
        }
        throw JmxMessages.MESSAGES.unknownDomain(domain);
    }

    private static boolean isResourceAddedOrRemovedNotification(Notification notification) {
        return notification.getType().equals("resource-added") || notification.getType().equals("resource-removed");
    }

    private static class ResourceRegistrationNotificationHandler
    implements NotificationHandler,
    org.jboss.as.controller.notification.NotificationFilter {
        private final MBeanServerDelegate delegate;
        private final String domain;
        private AtomicLong sequence = new AtomicLong(0L);

        private ResourceRegistrationNotificationHandler(MBeanServerDelegate delegate, String domain) {
            this.delegate = delegate;
            this.domain = domain;
        }

        public void handleNotification(Notification notification) {
            String jmxType = notification.getType().equals("resource-added") ? "JMX.mbean.registered" : "JMX.mbean.unregistered";
            ObjectName mbeanName = ObjectNameAddressUtil.createObjectName(this.domain, notification.getSource());
            MBeanServerNotification jmxNotification = new MBeanServerNotification(jmxType, (Object)MBeanServerDelegate.DELEGATE_NAME, this.sequence.incrementAndGet(), mbeanName);
            this.delegate.sendNotification(jmxNotification);
        }

        public boolean isNotificationEnabled(Notification notification) {
            return ModelControllerMBeanServerPlugin.isResourceAddedOrRemovedNotification(notification);
        }
    }

    private class JMXNotificationHandler
    implements NotificationHandler,
    org.jboss.as.controller.notification.NotificationFilter {
        private final String domain;
        private final ObjectName name;
        private final NotificationListener listener;
        private final NotificationFilter filter;
        private final Object handback;

        private JMXNotificationHandler(String domain, ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) {
            this.domain = domain;
            this.name = name;
            this.listener = listener;
            this.filter = filter;
            this.handback = handback;
        }

        public boolean isNotificationEnabled(Notification notification) {
            if (ModelControllerMBeanServerPlugin.isResourceAddedOrRemovedNotification(notification)) {
                return false;
            }
            if (this.filter == null) {
                return true;
            }
            javax.management.Notification jmxNotification = this.convert(notification);
            return this.filter.isNotificationEnabled(jmxNotification);
        }

        public void handleNotification(Notification notification) {
            javax.management.Notification jmxNotification = this.convert(notification);
            if (jmxNotification != null) {
                this.listener.handleNotification(jmxNotification, this.handback);
            }
        }

        private javax.management.Notification convert(Notification notification) {
            javax.management.Notification jmxNotification;
            long sequenceNumber = ModelControllerMBeanServerPlugin.this.notificationSequenceNumber.incrementAndGet();
            ObjectName source = ObjectNameAddressUtil.createObjectName(this.domain, notification.getSource());
            String message = notification.getMessage();
            long timestamp = notification.getTimestamp();
            String notificationType = notification.getType();
            if (notificationType.equals("attribute-value-written")) {
                ModelNode data = notification.getData();
                String attributeName = data.get("name").asString();
                String jmxAttributeName = NameConverter.convertToCamelCase(attributeName);
                try {
                    ModelNode modelDescription = ModelControllerMBeanServerPlugin.this.getHelper(source).getMBeanRegistration(source).getModelDescription(PathAddress.EMPTY_ADDRESS).getModelDescription(null);
                    ModelNode attributeDescription = modelDescription.get(new String[]{"attributes", attributeName});
                    TypeConverters converters = ModelControllerMBeanServerPlugin.this.getHelper(source).getConverters();
                    Object oldValue = converters.fromModelNode(attributeDescription, data.get("old-value"));
                    Object newValue = converters.fromModelNode(attributeDescription, data.get("new-value"));
                    String attributeType = converters.convertToMBeanType(attributeDescription).getTypeName();
                    jmxNotification = new AttributeChangeNotification(source, sequenceNumber, timestamp, message, jmxAttributeName, attributeType, oldValue, newValue);
                }
                catch (InstanceNotFoundException e) {
                    jmxNotification = new javax.management.Notification(notification.getType(), source, sequenceNumber, timestamp, message);
                }
            } else if (notificationType.equals("resource-added") || notificationType.equals("resource-removed")) {
                jmxNotification = null;
            } else {
                jmxNotification = new javax.management.Notification(notificationType, source, sequenceNumber, timestamp, message);
                jmxNotification.setUserData(notification.getData());
            }
            return jmxNotification;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JMXNotificationHandler that = (JMXNotificationHandler)o;
            if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) {
                return false;
            }
            if (this.handback != null ? !this.handback.equals(that.handback) : that.handback != null) {
                return false;
            }
            if (!this.listener.equals(that.listener)) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.listener.hashCode();
            result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
            result = 31 * result + (this.handback != null ? this.handback.hashCode() : 0);
            return result;
        }
    }
}

