/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.authentication.web;

import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.picketlink.Identity;
import org.picketlink.authentication.AuthenticationException;
import org.picketlink.authentication.web.BasicAuthenticationScheme;
import org.picketlink.authentication.web.HTTPAuthenticationScheme;
import org.picketlink.credential.DefaultLoginCredentials;
import org.picketlink.idm.credential.Token;
import org.picketlink.idm.credential.TokenCredential;

@ApplicationScoped
public class TokenAuthenticationScheme
implements HTTPAuthenticationScheme {
    public static final String AUTHORIZATION_TOKEN_HEADER_NAME = "Authorization";
    public static final String AUTHENTICATION_SCHEME_NAME = "Token";
    public static final String REQUIRES_AUTHENTICATION_HEADER_NAME = "WWW-Authenticate";
    @Inject
    private Instance<Identity> identityInstance;
    @Inject
    private Instance<DefaultLoginCredentials> credentialsInstance;
    @Inject
    private BasicAuthenticationScheme basicAuthenticationScheme;
    @Inject
    private Instance<Token.Provider> tokenProvider;

    @Override
    public void initialize(FilterConfig config) {
    }

    @Override
    public void extractCredential(HttpServletRequest request, DefaultLoginCredentials creds) {
        this.getPrimaryAuthenticationScheme().extractCredential(request, creds);
        if (creds.getCredential() == null) {
            this.extractTokenFromRequest(request, creds);
        }
    }

    @Override
    public void challengeClient(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.isPrimaryAuthenticationRequest()) {
            this.getPrimaryAuthenticationScheme().challengeClient(request, response);
        } else {
            response.setHeader(REQUIRES_AUTHENTICATION_HEADER_NAME, AUTHENTICATION_SCHEME_NAME);
            response.sendError(401);
        }
    }

    @Override
    public boolean postAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.isPrimaryAuthenticationRequest() && this.getIdentity().isLoggedIn()) {
            this.issueToken(request, response);
            return false;
        }
        return true;
    }

    @Override
    public boolean isProtected(HttpServletRequest request) {
        return true;
    }

    protected DefaultLoginCredentials getCredentials() {
        return (DefaultLoginCredentials)((Object)this.credentialsInstance.get());
    }

    protected Identity getIdentity() {
        return (Identity)this.identityInstance.get();
    }

    protected HTTPAuthenticationScheme getPrimaryAuthenticationScheme() {
        return this.basicAuthenticationScheme;
    }

    protected void extractTokenFromRequest(HttpServletRequest request, DefaultLoginCredentials creds) {
        String tokenValue;
        String authorizationHeader = request.getHeader(AUTHORIZATION_TOKEN_HEADER_NAME);
        if (authorizationHeader != null && authorizationHeader.contains(AUTHENTICATION_SCHEME_NAME) && (tokenValue = authorizationHeader.substring(AUTHENTICATION_SCHEME_NAME.length() + 1)) != null) {
            Token token = this.getTokenProvider().create((Object)tokenValue);
            creds.setCredential(new TokenCredential(token));
        }
    }

    protected void issueToken(HttpServletRequest request, HttpServletResponse response) {
        try {
            String token = this.getTokenProvider().issue(this.getIdentity().getAccount()).getToken();
            response.setStatus(200);
            response.getWriter().print("{\"authctoken\":\"" + token + "\"}");
        }
        catch (Exception e) {
            throw new AuthenticationException("Could not issue token.", e);
        }
    }

    private boolean isPrimaryAuthenticationRequest() {
        return this.getCredentials().getCredential() != null && !TokenCredential.class.isInstance(this.getCredentials().getCredential());
    }

    private Token.Provider getTokenProvider() {
        if (this.tokenProvider.isAmbiguous() || this.tokenProvider.isUnsatisfied()) {
            throw new AuthenticationException("You must provide exactly one " + Token.Provider.class.getName() + " implementation.");
        }
        return (Token.Provider)this.tokenProvider.get();
    }
}

