/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.service;

import java.security.AccessController;
import java.util.List;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.ServiceRegistry;

public class SecuredServiceRegistry
implements ServiceRegistry {
    public static final RuntimePermission PERMISSION = new RuntimePermission("org.jboss.as.server.deployment.service.USE_SERVICE_REGISTRY");
    private final ServiceRegistry delegate;

    public SecuredServiceRegistry(ServiceRegistry delegate) {
        this.delegate = delegate;
    }

    public ServiceController<?> getRequiredService(ServiceName serviceName) throws ServiceNotFoundException {
        AccessController.checkPermission(PERMISSION);
        return this.delegate.getRequiredService(serviceName);
    }

    public ServiceController<?> getService(ServiceName serviceName) {
        AccessController.checkPermission(PERMISSION);
        return this.delegate.getService(serviceName);
    }

    public List<ServiceName> getServiceNames() {
        AccessController.checkPermission(PERMISSION);
        return this.delegate.getServiceNames();
    }
}

