/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Logger;
import org.jboss.security.auth.callback.SecurityAssociationHandler;
import org.jboss.security.negotiation.net.InitSPNEGOContextAction;
import org.jboss.security.negotiation.net.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPNEGOSocket
extends Socket {
    protected static Logger log = Logger.getLogger(SPNEGOSocket.class);
    private LoginContext lc;

    public SPNEGOSocket() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Creating " + this.getClass().getName()));
        }
    }

    public SPNEGOSocket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        super(address, port, localAddr, localPort);
    }

    public SPNEGOSocket(InetAddress address, int port) throws IOException {
        super(address, port);
    }

    public SPNEGOSocket(String host, int port, InetAddress localAddr, int localPort) throws IOException {
        super(host, port, localAddr, localPort);
    }

    public SPNEGOSocket(String host, int port) throws UnknownHostException, IOException {
        super(host, port);
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        super.connect(endpoint);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        boolean TRACE = log.isTraceEnabled();
        if (TRACE) {
            log.trace((Object)(this.getClass().getName() + ".connect()"));
        }
        super.connect(endpoint, timeout);
        Subject subject = null;
        try {
            if (TRACE) {
                log.trace((Object)"Invoking login");
            }
            subject = this.login();
            if (TRACE) {
                log.trace((Object)"Login was successful");
            }
        }
        catch (LoginException le) {
            log.error((Object)("Failed to login: " + le.getMessage()), (Throwable)le);
        }
        if (subject != null) {
            if (TRACE) {
                log.trace((Object)"Running PrivilegedAction");
            }
            PrivilegedAction<Object> action = this.getPrivilegedAction();
            Subject.doAs(subject, action);
        }
        try {
            if (TRACE) {
                log.trace((Object)"Invoking logout");
            }
            this.logout();
            if (TRACE) {
                log.trace((Object)"Logout was successful");
            }
        }
        catch (LoginException le) {
            log.error((Object)("Failed to logout: " + le.getMessage()), (Throwable)le);
        }
    }

    protected Subject login() throws LoginException {
        String securityDomainName = SecurityActions.getClientSecurityDomain();
        this.lc = new LoginContext(securityDomainName, (CallbackHandler)new SecurityAssociationHandler());
        this.lc.login();
        return this.lc.getSubject();
    }

    protected void logout() throws LoginException {
        if (this.lc != null) {
            this.lc.logout();
        }
    }

    protected PrivilegedAction<Object> getPrivilegedAction() {
        return new InitSPNEGOContextAction(this, this.lc);
    }
}

