/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.sasl.util.UsernamePasswordHashUtil;
import org.jboss.security.auth.spi.UsersRolesLoginModule;

public class RealmUsersRolesLoginModule
extends UsersRolesLoginModule {
    private static final String REALM_OPTION = "realm";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"realm"};
    private UsernamePasswordHashUtil usernamePasswordHashUtil;
    private String realm;

    public RealmUsersRolesLoginModule() {
        try {
            this.usernamePasswordHashUtil = new UsernamePasswordHashUtil();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.addValidOptions(ALL_VALID_OPTIONS);
        this.realm = (String)options.get(REALM_OPTION);
        HashMap map = new HashMap(options);
        map.putAll(options);
        map.put("hashAlgorithm", "REALM");
        map.put("hashStorePassword", "false");
        super.initialize(subject, callbackHandler, sharedState, map);
    }

    protected String createPasswordHash(String username, String password, String digestOption) throws LoginException {
        return this.usernamePasswordHashUtil.generateHashedHexURP(username, this.realm, password.toCharArray());
    }
}

