/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter.etcl;

import antlr.Token;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.filter.RuntimeVariable;
import org.jacorb.notification.filter.etcl.AbstractTCLNode;
import org.jacorb.notification.filter.etcl.AbstractTCLVisitor;
import org.jacorb.notification.filter.etcl.CurrentTimeNode;
import org.jacorb.notification.filter.etcl.DomainNameShorthandNode;
import org.jacorb.notification.filter.etcl.EventNameShorthandNode;
import org.jacorb.notification.filter.etcl.PropertyShorthandNode;
import org.jacorb.notification.filter.etcl.TypeNameShorthandNode;
import org.jacorb.notification.filter.etcl.VisitorException;

public class RuntimeVariableNode
extends AbstractTCLNode
implements RuntimeVariable {
    private final String value_;
    private final AbstractTCLNode strategy_;

    public RuntimeVariableNode(Token token) {
        super(token);
        this.value_ = token.getText();
        this.strategy_ = this.newStrategy(this.value_);
    }

    public EvaluationResult evaluate(EvaluationContext context) throws EvaluationException {
        return this.strategy_.evaluate(context);
    }

    private AbstractTCLNode newStrategy(String variable) {
        if ("domain_name".equals(variable)) {
            return new DomainNameShorthandNode();
        }
        if ("type_name".equals(variable)) {
            return new TypeNameShorthandNode();
        }
        if ("event_name".equals(variable)) {
            return new EventNameShorthandNode();
        }
        if ("curtime".equals(variable)) {
            return new CurrentTimeNode();
        }
        return new PropertyShorthandNode(variable);
    }

    public void acceptPostOrder(AbstractTCLVisitor visitor) throws VisitorException {
        if (this.getFirstChild() != null) {
            ((AbstractTCLNode)this.getFirstChild()).acceptPostOrder(visitor);
        }
        visitor.visitRuntimeVariable(this);
    }

    public void acceptPreOrder(AbstractTCLVisitor visitor) throws VisitorException {
        visitor.visitRuntimeVariable(this);
        if (this.getFirstChild() != null) {
            ((AbstractTCLNode)this.getFirstChild()).acceptPreOrder(visitor);
        }
    }

    public void acceptInOrder(AbstractTCLVisitor visitor) throws VisitorException {
        if (this.getFirstChild() != null) {
            ((AbstractTCLNode)this.getFirstChild()).acceptInOrder(visitor);
        }
        visitor.visitRuntimeVariable(this);
    }

    public String toString() {
        return this.value_;
    }

    public String getIdentifier() {
        return this.value_;
    }
}

