/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mod_cluster.undertow;

import io.undertow.servlet.api.Deployment;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.jboss.modcluster.container.Connector;
import org.jboss.modcluster.container.ContainerEventHandler;
import org.jboss.modcluster.container.Context;
import org.jboss.modcluster.container.Engine;
import org.jboss.modcluster.container.Server;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.Value;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.ListenerService;
import org.wildfly.extension.undertow.UndertowEventListener;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.mod_cluster.undertow.UndertowConnector;
import org.wildfly.mod_cluster.undertow.UndertowContext;
import org.wildfly.mod_cluster.undertow.UndertowEngine;
import org.wildfly.mod_cluster.undertow.UndertowHost;
import org.wildfly.mod_cluster.undertow.UndertowServer;
import org.wildfly.security.manager.action.GetAccessControlContextAction;

public class UndertowEventHandlerAdapter
implements UndertowEventListener,
Service<Void>,
Runnable {
    private static final Logger log = Logger.getLogger(UndertowEventHandlerAdapter.class);
    private final Value<ListenerService> listener;
    private final Value<UndertowService> service;
    private final Value<ContainerEventHandler> eventHandler;
    private volatile ScheduledExecutorService executor;
    private volatile Server server;
    private volatile Connector connector;

    public UndertowEventHandlerAdapter(Value<ContainerEventHandler> eventHandler, Value<UndertowService> service, Value<ListenerService> listener) {
        this.eventHandler = eventHandler;
        this.service = service;
        this.listener = listener;
    }

    public Void getValue() {
        return null;
    }

    public void start(StartContext context) {
        UndertowService service = (UndertowService)this.service.getValue();
        ContainerEventHandler eventHandler = (ContainerEventHandler)this.eventHandler.getValue();
        this.connector = new UndertowConnector((ListenerService)this.listener.getValue());
        this.server = new UndertowServer(service, this.connector);
        service.registerListener((UndertowEventListener)this);
        eventHandler.init(this.server);
        eventHandler.start(this.server);
        ThreadGroup group = new ThreadGroup(UndertowEventHandlerAdapter.class.getSimpleName());
        JBossThreadFactory factory = new JBossThreadFactory(group, Boolean.FALSE, null, "%G - %t", null, null, (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance()));
        this.executor = Executors.newScheduledThreadPool(1, (ThreadFactory)factory);
        this.executor.scheduleWithFixedDelay(this, 0L, 10L, TimeUnit.SECONDS);
    }

    public void stop(StopContext context) {
        ((UndertowService)this.service.getValue()).unregisterListener((UndertowEventListener)this);
        this.executor.shutdown();
        ContainerEventHandler eventHandler = (ContainerEventHandler)this.eventHandler.getValue();
        eventHandler.stop(this.server);
    }

    private Context createContext(Deployment deployment, Host host) {
        return new UndertowContext(deployment, new UndertowHost(host, new UndertowEngine(host.getServer().getValue(), (UndertowService)this.service.getValue(), this.connector)));
    }

    public void onDeploymentStart(Deployment deployment, Host host) {
        Context context = this.createContext(deployment, host);
        ((ContainerEventHandler)this.eventHandler.getValue()).add(context);
        ((ContainerEventHandler)this.eventHandler.getValue()).start(context);
    }

    public void onDeploymentStop(Deployment deployment, Host host) {
        Context context = this.createContext(deployment, host);
        ((ContainerEventHandler)this.eventHandler.getValue()).stop(context);
        ((ContainerEventHandler)this.eventHandler.getValue()).remove(context);
    }

    public void onShutdown() {
    }

    public void onHostStart(Host host) {
    }

    public void onHostStop(Host host) {
    }

    public void onServerStart(org.wildfly.extension.undertow.Server server) {
    }

    public void onServerStop(org.wildfly.extension.undertow.Server server) {
    }

    @Override
    public void run() {
        try {
            for (Engine engine : this.server.getEngines()) {
                ((ContainerEventHandler)this.eventHandler.getValue()).status(engine);
            }
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
        }
    }
}

