/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.recovery.transactions;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.Header;
import com.arjuna.ats.internal.jts.orbspecific.coordinator.ArjunaTransactionImple;
import com.arjuna.ats.internal.jts.recovery.contact.StatusChecker;
import com.arjuna.ats.internal.jts.recovery.transactions.AssumedCompleteTransaction;
import com.arjuna.ats.internal.jts.recovery.transactions.RecoveringTransaction;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.ats.jts.utils.Utility;
import java.io.IOException;
import java.util.Date;
import org.omg.CORBA.SystemException;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;

public class RecoveredTransaction
extends ArjunaTransactionImple
implements RecoveringTransaction {
    private String _typeName;
    private boolean _reportHeuristics = false;
    private int _recoveryStatus = 0;
    protected Uid _originalProcessUid;
    private Status _txStatus;

    public RecoveredTransaction(Uid actionUid) {
        this(actionUid, "");
    }

    public RecoveredTransaction(Uid actionUid, String changedTypeName) {
        super(actionUid);
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug((Object)("RecoveredTransaction " + this.get_uid() + " created"));
        }
        this._recoveryStatus = 2;
        String effectiveTypeName = RecoveredTransaction.typeName();
        if (changedTypeName.length() < 1) {
            this._typeName = null;
        } else {
            this._typeName = changedTypeName;
            effectiveTypeName = changedTypeName;
        }
        this._originalProcessUid = new Uid(Uid.nullUid());
        try {
            if (StoreManager.getRecoveryStore().currentState(actionUid, effectiveTypeName) != -1) {
                if (this.activate()) {
                    this._recoveryStatus = 1;
                } else {
                    jtsLogger.i18NLogger.warn_recovery_transactions_RecoveredTransaction_2(actionUid);
                }
            }
        }
        catch (Exception e) {
            jtsLogger.i18NLogger.warn_recovery_transactions_RecoveredTransaction_3(actionUid, e);
        }
        this._txStatus = Status.StatusUnknown;
    }

    @Override
    public synchronized Status get_status() throws SystemException {
        if (this._txStatus != Status.StatusUnknown) {
            return this._txStatus;
        }
        Status theStatus = Status.StatusUnknown;
        theStatus = this._recoveryStatus == 2 ? Status.StatusRolledBack : super.get_status();
        return theStatus;
    }

    @Override
    public Status getOriginalStatus() {
        if (this._recoveryStatus != 2) {
            try {
                return StatusChecker.get_status(this.get_uid(), this._originalProcessUid);
            }
            catch (Inactive ex) {
                return Status.StatusUnknown;
            }
        }
        return Status.StatusUnknown;
    }

    @Override
    public void addResourceRecord(Uid rcUid, Resource r) {
        Coordinator coord = null;
        AbstractRecord corbaRec = this.createOTSRecord(true, r, coord, rcUid);
        this.addRecord(corbaRec);
    }

    @Override
    public void replayPhase2() {
        this._recoveryStatus = 3;
        Status theStatus = this.get_status();
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug((Object)("RecoveredTransaction.replayPhase2 (" + this.get_uid() + ") - status = " + Utility.stringStatus(theStatus)));
        }
        if (theStatus == Status.StatusPrepared || theStatus == Status.StatusCommitting || theStatus == Status.StatusCommitted) {
            this.phase2Commit(this._reportHeuristics);
            this._recoveryStatus = 4;
            this._txStatus = Status.StatusCommitted;
        } else if (theStatus == Status.StatusRolledBack || theStatus == Status.StatusRollingBack || theStatus == Status.StatusMarkedRollback) {
            this.phase2Abort(this._reportHeuristics);
            this._recoveryStatus = 4;
            this._txStatus = Status.StatusRolledBack;
        } else {
            jtsLogger.i18NLogger.warn_recovery_transactions_RecoveredTransaction_6(Utility.stringStatus(theStatus));
            this._recoveryStatus = 5;
        }
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug((Object)("RecoveredTransaction.replayPhase2 (" + this.get_uid() + ") - status = " + Utility.stringStatus(theStatus)));
        }
    }

    @Override
    public int getRecoveryStatus() {
        return this._recoveryStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allCompleted() {
        RecoveredTransaction recoveredTransaction = this;
        synchronized (recoveredTransaction) {
            if (this.preparedList != null && this.preparedList.size() > 0) {
                return false;
            }
            if (this.failedList != null && this.failedList.size() > 0) {
                return false;
            }
            if (this.pendingList != null && this.pendingList.size() > 0) {
                return false;
            }
            return this.heuristicList == null || this.heuristicList.size() <= 0;
            {
            }
        }
    }

    @Override
    public String type() {
        if (this._typeName == null) {
            return super.type();
        }
        return this._typeName;
    }

    @Override
    public void removeOldStoreEntry() {
        try {
            this.getStore().remove_committed(this.get_uid(), super.type());
        }
        catch (ObjectStoreException ex) {
            jtsLogger.i18NLogger.warn_recovery_transactions_RecoveredTransaction_8(ex);
        }
    }

    @Override
    public boolean assumeComplete() {
        this._typeName = AssumedCompleteTransaction.typeName();
        return true;
    }

    @Override
    protected void packHeader(OutputObjectState os, Header hdr) throws IOException {
        super.packHeader(os, new Header(hdr.getTxId(), this._originalProcessUid));
    }

    @Override
    protected void unpackHeader(InputObjectState os, Header hdr) throws IOException {
        super.unpackHeader(os, hdr);
        this._originalProcessUid = hdr.getProcessId();
    }

    @Override
    public boolean save_state(OutputObjectState objectState, int ot) {
        boolean result = super.save_state(objectState, ot);
        if (this._typeName != null && result) {
            Date lastActiveTime = new Date();
            try {
                objectState.packLong(lastActiveTime.getTime());
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public Date getLastActiveTime() {
        return null;
    }
}

