/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.hornetq.core.security.HornetQPrincipal;
import org.hornetq.core.server.ActivateCallback;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.jms.server.impl.JMSServerManagerImpl;
import org.hornetq.spi.core.naming.BindingRegistry;
import org.jboss.as.messaging.HornetQActivationService;
import org.jboss.as.messaging.HornetQDefaultCredentials;
import org.jboss.as.messaging.MessagingLogger;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.jms.AS7BindingRegistry;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.server.Services;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.security.manager.WildFlySecurityManager;

public class JMSService
implements Service<JMSServerManager> {
    private final InjectedValue<HornetQServer> hornetQServer = new InjectedValue();
    private final InjectedValue<ExecutorService> serverExecutor = new InjectedValue();
    private final ServiceName hqServiceName;
    private JMSServerManager jmsServer;

    public static ServiceController<JMSServerManager> addService(ServiceTarget target, ServiceName hqServiceName, ServiceListener<Object> ... listeners) {
        JMSService service = new JMSService(hqServiceName);
        ServiceBuilder builder = target.addService(JMSServices.getJmsManagerBaseServiceName(hqServiceName), (Service)service).addDependency(hqServiceName, HornetQServer.class, service.hornetQServer).addListener(listeners).setInitialMode(ServiceController.Mode.ACTIVE);
        Services.addServerExecutorDependency((ServiceBuilder)builder, service.serverExecutor, (boolean)false);
        return builder.install();
    }

    protected JMSService(ServiceName hqServiceName) {
        this.hqServiceName = hqServiceName;
    }

    public synchronized JMSServerManager getValue() throws IllegalStateException {
        if (this.jmsServer == null) {
            throw new IllegalStateException();
        }
        return this.jmsServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(final StartContext context) throws StartException {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    JMSService.this.doStart(context);
                    context.complete();
                }
                catch (StartException e) {
                    context.failed(e);
                }
            }
        };
        try {
            ((ExecutorService)this.serverExecutor.getValue()).submit(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(final StopContext context) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                JMSService.this.doStop(context);
                context.complete();
            }
        };
        try {
            ((ExecutorService)this.serverExecutor.getValue()).submit(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    private synchronized void doStart(StartContext context) throws StartException {
        final ServiceContainer serviceContainer = context.getController().getServiceContainer();
        ClassLoader oldTccl = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(this.getClass());
        try {
            this.jmsServer = new JMSServerManagerImpl((HornetQServer)this.hornetQServer.getValue(), (BindingRegistry)new AS7BindingRegistry(context.getController().getServiceContainer()));
            ((HornetQServer)this.hornetQServer.getValue()).registerActivateCallback(new ActivateCallback(){
                private volatile ServiceController<Void> hornetqActivationController;

                public void preActivate() {
                }

                public void activated() {
                    ((HornetQServer)JMSService.this.hornetQServer.getValue()).getRemotingService().allowInvmSecurityOverride(new HornetQPrincipal(HornetQDefaultCredentials.getUsername(), HornetQDefaultCredentials.getPassword()));
                    if (this.hornetqActivationController == null) {
                        this.hornetqActivationController = serviceContainer.addService(HornetQActivationService.getHornetQActivationServiceName(JMSService.this.hqServiceName), (Service)new HornetQActivationService()).setInitialMode(ServiceController.Mode.ACTIVE).install();
                    } else {
                        this.hornetqActivationController.setMode(ServiceController.Mode.ACTIVE);
                    }
                }

                public void deActivate() {
                    if (this.hornetqActivationController != null && !this.hornetqActivationController.getState().in(new ServiceController.State[]{ServiceController.State.STOPPING, ServiceController.State.REMOVED})) {
                        this.hornetqActivationController.compareAndSetMode(ServiceController.Mode.ACTIVE, ServiceController.Mode.REMOVE);
                        this.hornetqActivationController = null;
                    }
                }
            });
            this.jmsServer.start();
        }
        catch (StartException e) {
            throw e;
        }
        catch (Exception e) {
            throw MessagingMessages.MESSAGES.failedToStartService(e);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
        }
    }

    private synchronized void doStop(StopContext context) {
        try {
            this.jmsServer.stop();
            this.jmsServer = null;
        }
        catch (Exception e) {
            MessagingLogger.MESSAGING_LOGGER.errorStoppingJmsServer(e);
        }
    }
}

