/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.channels.FixedLengthOverflowException;
import org.xnio.channels.FixedLengthUnderflowException;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.StreamSinkConduit;

public abstract class AbstractFixedLengthStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private int config;
    private long state;
    private boolean broken = false;
    private static final int CONF_FLAG_CONFIGURABLE = 1;
    private static final int CONF_FLAG_PASS_CLOSE = 2;
    private static final long FLAG_CLOSE_REQUESTED = Long.MIN_VALUE;
    private static final long FLAG_CLOSE_COMPLETE = 0x4000000000000000L;
    private static final long FLAG_FINISHED_CALLED = 0x2000000000000000L;
    private static final long MASK_COUNT = Bits.longBitMask((int)0, (int)60);

    public AbstractFixedLengthStreamSinkConduit(StreamSinkConduit next, long contentLength, boolean configurable, boolean propagateClose) {
        super(next);
        if (contentLength < 0L) {
            throw new IllegalArgumentException("Content length must be greater than or equal to zero");
        }
        if (contentLength > MASK_COUNT) {
            throw new IllegalArgumentException("Content length is too long");
        }
        this.config = (configurable ? 1 : 0) | (propagateClose ? 2 : 0);
        this.state = contentLength;
    }

    protected void reset(long contentLength, boolean propagateClose) {
        this.state = contentLength;
        this.config = propagateClose ? (this.config |= 2) : (this.config &= 0xFFFFFFFD);
    }

    public int write(ByteBuffer src) throws IOException {
        long val = this.state;
        long remaining = val & MASK_COUNT;
        if (!src.hasRemaining()) {
            return 0;
        }
        if (Bits.allAreSet((long)val, (long)Long.MIN_VALUE)) {
            throw new ClosedChannelException();
        }
        int oldLimit = src.limit();
        if (remaining == 0L) {
            throw new FixedLengthOverflowException();
        }
        if ((long)src.remaining() > remaining) {
            src.limit((int)((long)src.position() + remaining));
        }
        int res = 0;
        try {
            int n = res = ((StreamSinkConduit)this.next).write(src);
            return n;
        }
        catch (IOException e) {
            this.broken = true;
            throw e;
        }
        finally {
            src.limit(oldLimit);
            this.exitWrite(val, res);
        }
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (length == 0) {
            return 0L;
        }
        if (length == 1) {
            return this.write(srcs[offset]);
        }
        long val = this.state;
        long remaining = val & MASK_COUNT;
        if (Bits.allAreSet((long)val, (long)Long.MIN_VALUE)) {
            throw new ClosedChannelException();
        }
        long toWrite = Buffers.remaining((Buffer[])srcs, (int)offset, (int)length);
        if (remaining == 0L) {
            throw new FixedLengthOverflowException();
        }
        int[] limits = null;
        if (toWrite > remaining) {
            limits = new int[length];
            long r = remaining;
            for (int i = offset; i < offset + length; ++i) {
                limits[i - offset] = srcs[i].limit();
                int br = srcs[i].remaining();
                if ((long)br < r) {
                    r -= (long)br;
                    continue;
                }
                srcs[i].limit((int)((long)srcs[i].position() + r));
                r = 0L;
            }
        }
        long res = 0L;
        try {
            long i = res = ((StreamSinkConduit)this.next).write(srcs, offset, length);
            return i;
        }
        catch (IOException e) {
            this.broken = true;
            throw e;
        }
        finally {
            if (limits != null) {
                for (int i = offset; i < offset + length; ++i) {
                    srcs[i].limit(limits[i - offset]);
                }
            }
            this.exitWrite(val, res);
        }
    }

    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        try {
            return Conduits.writeFinalBasic((StreamSinkConduit)this, (ByteBuffer[])srcs, (int)offset, (int)length);
        }
        catch (IOException e) {
            this.broken = true;
            throw e;
        }
    }

    public int writeFinal(ByteBuffer src) throws IOException {
        try {
            return Conduits.writeFinalBasic((StreamSinkConduit)this, (ByteBuffer)src);
        }
        catch (IOException e) {
            this.broken = true;
            throw e;
        }
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (count == 0L) {
            return 0L;
        }
        long val = this.state;
        if (Bits.allAreSet((long)val, (long)Long.MIN_VALUE)) {
            throw new ClosedChannelException();
        }
        if (Bits.allAreClear((long)val, (long)MASK_COUNT)) {
            throw new FixedLengthOverflowException();
        }
        long res = 0L;
        try {
            long l = res = ((StreamSinkConduit)this.next).transferFrom(src, position, Math.min(count, val & MASK_COUNT));
            return l;
        }
        catch (IOException e) {
            this.broken = true;
            throw e;
        }
        finally {
            this.exitWrite(val, res);
        }
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (count == 0L) {
            return 0L;
        }
        long val = this.state;
        if (Bits.allAreSet((long)val, (long)Long.MIN_VALUE)) {
            throw new ClosedChannelException();
        }
        if (Bits.allAreClear((long)val, (long)MASK_COUNT)) {
            throw new FixedLengthOverflowException();
        }
        long res = 0L;
        try {
            long l = res = ((StreamSinkConduit)this.next).transferFrom(source, Math.min(count, val & MASK_COUNT), throughBuffer);
            return l;
        }
        catch (IOException e) {
            this.broken = true;
            throw e;
        }
        finally {
            this.exitWrite(val, res);
        }
    }

    public boolean flush() throws IOException {
        long val = this.state;
        if (Bits.anyAreSet((long)val, (long)0x4000000000000000L)) {
            return true;
        }
        boolean flushed = false;
        try {
            boolean bl = flushed = ((StreamSinkConduit)this.next).flush();
            return bl;
        }
        catch (IOException e) {
            this.broken = true;
            throw e;
        }
        finally {
            this.exitFlush(val, flushed);
        }
    }

    public boolean isWriteResumed() {
        return Bits.allAreClear((long)this.state, (long)0x4000000000000000L) && ((StreamSinkConduit)this.next).isWriteResumed();
    }

    public void wakeupWrites() {
        long val = this.state;
        if (Bits.anyAreSet((long)val, (long)0x4000000000000000L)) {
            return;
        }
        ((StreamSinkConduit)this.next).wakeupWrites();
    }

    public void terminateWrites() throws IOException {
        long val = this.enterShutdown();
        if (Bits.anyAreSet((long)val, (long)MASK_COUNT) && !this.broken) {
            try {
                throw new FixedLengthUnderflowException((val & MASK_COUNT) + " bytes remaining");
            }
            catch (Throwable throwable) {
                ((StreamSinkConduit)this.next).truncateWrites();
                throw throwable;
            }
        }
        if (Bits.allAreSet((int)this.config, (int)2)) {
            ((StreamSinkConduit)this.next).terminateWrites();
        }
    }

    public void awaitWritable() throws IOException {
        ((StreamSinkConduit)this.next).awaitWritable();
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        ((StreamSinkConduit)this.next).awaitWritable(time, timeUnit);
    }

    public long getRemaining() {
        return this.state & MASK_COUNT;
    }

    private void exitWrite(long oldVal, long consumed) {
        long newVal;
        this.state = newVal = oldVal - consumed;
    }

    private void exitFlush(long oldVal, boolean flushed) {
        long newVal = oldVal;
        boolean callFinish = false;
        if ((Bits.anyAreSet((long)oldVal, (long)Long.MIN_VALUE) || (newVal & MASK_COUNT) == 0L) && flushed) {
            if (!Bits.anyAreSet((long)oldVal, (long)0x2000000000000000L) && ((newVal |= 0x4000000000000000L) & MASK_COUNT) == 0L) {
                newVal |= 0x2000000000000000L;
                callFinish = true;
            }
            this.state = newVal;
            if (callFinish) {
                this.channelFinished();
            }
        }
    }

    protected void channelFinished() {
    }

    private long enterShutdown() {
        long oldVal = this.state;
        if (Bits.anyAreSet((long)oldVal, (long)-4611686018427387904L)) {
            return oldVal;
        }
        long newVal = oldVal | Long.MIN_VALUE;
        if (Bits.anyAreSet((long)oldVal, (long)MASK_COUNT)) {
            newVal |= 0x4000000000000000L;
        }
        this.state = newVal;
        return oldVal;
    }
}

