/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust;

import java.util.ArrayList;
import java.util.Hashtable;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.wstrust.STSClient;
import org.picketlink.identity.federation.core.wstrust.STSClientConfig;
import org.picketlink.identity.federation.core.wstrust.STSClientConfigKeyProvider;
import org.picketlink.identity.federation.core.wstrust.STSClientCreationCallBack;
import org.picketlink.identity.federation.core.wstrust.STSConfigData;

public class STSClientPool {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    static final int DEFAULT_NUM_STS_CLIENTS = 10;
    private int maxPoolSize = 0;
    private Hashtable<String, ArrayList<STSClient>> free = new Hashtable();
    private Hashtable<String, ArrayList<STSClient>> inUse = new Hashtable();
    private Hashtable<String, STSConfigData> configs = new Hashtable();

    STSClientPool() {
    }

    synchronized void initializePool(int maxPoolSize) {
        if (maxPoolSize < 0) {
            throw logger.cannotSetMaxPoolSizeToNegative(String.valueOf(maxPoolSize));
        }
        this.maxPoolSize = maxPoolSize;
    }

    public void initialize(int numberOfSTSClients, STSClientConfig stsClientConfig) {
        this.internalInitialize(numberOfSTSClients, stsClientConfig, null);
    }

    public void initialize(STSClientConfig stsClientConfig) {
        this.internalInitialize(0, stsClientConfig, null);
    }

    public void initialize(int numberOfSTSClients, STSClientCreationCallBack clientCreationCallBack) {
        this.internalInitialize(numberOfSTSClients, null, clientCreationCallBack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalInitialize(int numberOfSTSClients, STSClientConfig stsClientConfig, STSClientCreationCallBack clientCreationCallBack) {
        int initSTSCLients = numberOfSTSClients > 0 ? numberOfSTSClients : 10;
        String key = null;
        key = clientCreationCallBack != null ? clientCreationCallBack.getKey() : this.key(stsClientConfig);
        if (!this.free.containsKey(key)) {
            int i;
            ArrayList<STSClient> clients = new ArrayList<STSClient>(initSTSCLients);
            if (clientCreationCallBack != null) {
                for (i = 0; i < initSTSCLients; ++i) {
                    clients.add(clientCreationCallBack.createClient());
                }
            } else {
                for (i = 0; i < initSTSCLients; ++i) {
                    clients.add(new STSClient(stsClientConfig));
                }
            }
            Hashtable<String, ArrayList<STSClient>> hashtable = this.free;
            synchronized (hashtable) {
                STSConfigData configData = new STSConfigData();
                configData.initialNumberOfClients = initSTSCLients;
                if (clientCreationCallBack != null) {
                    configData.config = null;
                    configData.callBack = clientCreationCallBack;
                } else {
                    configData.config = stsClientConfig;
                    configData.callBack = null;
                }
                this.configs.put(key, configData);
                this.free.put(key, clients);
                this.inUse.put(key, new ArrayList(initSTSCLients));
            }
        }
        throw logger.freePoolAlreadyContainsGivenKey(key);
    }

    public STSClient takeOut(STSClientConfig stsClientConfig) {
        String key = this.key(stsClientConfig);
        STSClient client = this.takeOutInternal(key);
        if (client == null) {
            STSConfigData configData = this.configs.get(key);
            if (configData == null) {
                throw logger.cannotGetSTSConfigByKey(key);
            }
            this.initialize(configData.initialNumberOfClients, stsClientConfig);
            client = this.takeOutInternal(key);
        }
        return client;
    }

    public STSClient takeOut(String key) {
        STSClient client = this.takeOutInternal(key);
        if (client == null) {
            STSConfigData configData = this.configs.get(key);
            if (configData == null) {
                throw logger.cannotGetSTSConfigByKey(key);
            }
            if (configData.callBack != null) {
                this.internalInitialize(10, null, this.configs.get((Object)key).callBack);
            }
            client = this.takeOutInternal(key);
        }
        return client;
    }

    public boolean isConfigInitialized(STSClientConfig stsClientConfig) {
        if (!this.isPoolingDisabled() || stsClientConfig == null) {
            return false;
        }
        STSConfigData configData = this.configs.get(this.key(stsClientConfig));
        return configData != null;
    }

    public boolean isConfigInitialized(String key) {
        if (!this.isPoolingDisabled() || key == null) {
            return false;
        }
        STSConfigData configData = this.configs.get(key);
        return configData != null;
    }

    public void putIn(STSClientConfigKeyProvider keyProvider, STSClient client) {
        if (!this.isPoolingDisabled()) {
            String key = keyProvider.getSTSClientConfigKey();
            this.putInInternal(key, client);
        }
    }

    public void putIn(String key, STSClient client) {
        if (!this.isPoolingDisabled()) {
            this.putInInternal(key, client);
        }
    }

    public void putIn(STSClient client) {
        if (!this.isPoolingDisabled()) {
            this.putInInternal(client.getSTSClientConfigKey(), client);
        }
    }

    private synchronized STSClient takeOutInternal(String key) {
        ArrayList<STSClient> clients = this.free.get(key);
        if (clients != null) {
            STSClient client;
            int size = clients.size();
            if (size > 0) {
                client = clients.remove(size - 1);
            } else {
                int allocateClients = this.numClientsToAllocate(key);
                if (allocateClients <= 0) {
                    throw logger.maximumNumberOfClientsReachedforPool(String.valueOf(this.maxPoolSize));
                }
                this.addClients(key);
                client = clients.remove(clients.size() - 1);
            }
            this.markInUse(key, client);
            return client;
        }
        return null;
    }

    private int numClientsToAllocate(String key) {
        STSConfigData configData;
        int initSTSCLients;
        int c;
        int allClients = 0;
        ArrayList<STSClient> clients = this.inUse.get(key);
        if (clients != null) {
            allClients += clients.size();
        }
        if ((clients = this.free.get(key)) != null) {
            allClients += clients.size();
        }
        if ((c = this.maxPoolSize - allClients) > (initSTSCLients = (configData = this.configs.get(key)) != null ? configData.initialNumberOfClients : 10)) {
            return initSTSCLients;
        }
        if (c <= 0) {
            return 0;
        }
        return c;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addClients(String key) {
        STSConfigData configData = this.configs.get(key);
        if (configData == null) throw logger.cannotGetSTSConfigByKey(key);
        ArrayList<STSClient> freeClientPool = this.free.get(key);
        if (freeClientPool == null) throw logger.cannotGetFreeClientPoolKey(key);
        ArrayList<STSClient> clients = new ArrayList<STSClient>(configData.initialNumberOfClients);
        if (configData.config != null) {
            for (int i = 0; i < configData.initialNumberOfClients; ++i) {
                clients.add(new STSClient(configData.config));
            }
        } else {
            for (int i = 0; i < configData.initialNumberOfClients; ++i) {
                clients.add(configData.callBack.createClient());
            }
        }
        freeClientPool.addAll(clients);
    }

    private void markInUse(String key, STSClient client) {
        ArrayList<STSClient> usedClients = this.inUse.get(key);
        if (usedClients != null) {
            usedClients.add(client);
        } else {
            logger.cannotGetUsedClientsByKey(key);
        }
    }

    private synchronized void putInInternal(String key, STSClient client) {
        ArrayList<STSClient> freeClients = this.free.get(key);
        ArrayList<STSClient> usedClients = this.inUse.get(key);
        if (!usedClients.remove(client)) {
            throw logger.removingNonExistingClientFromUsedClientsByKey(key);
        }
        freeClients.add(client);
    }

    private String key(STSClientConfig stsClientConfig) {
        return stsClientConfig.getSTSClientConfigKey();
    }

    public boolean isPoolingDisabled() {
        return this.maxPoolSize == 0;
    }
}

