/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import java.util.ArrayList;
import java.util.Collection;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.server.group.CacheNodeFactory;
import org.wildfly.clustering.server.group.ChannelNodeFactory;

public class CacheNodeFactoryService
extends AbstractService<CacheNodeFactory>
implements CacheNodeFactory {
    private final Value<ChannelNodeFactory> factory;

    public CacheNodeFactoryService(Value<ChannelNodeFactory> factory) {
        this.factory = factory;
    }

    public Node createNode(Address address) {
        return ((ChannelNodeFactory)this.factory.getValue()).createNode(CacheNodeFactoryService.toJGroupsAddress(address));
    }

    @Override
    public void invalidate(Collection<Address> addresses) {
        if (!addresses.isEmpty()) {
            ArrayList<org.jgroups.Address> jgroupsAddresses = new ArrayList<org.jgroups.Address>(addresses.size());
            for (Address address : addresses) {
                jgroupsAddresses.add(CacheNodeFactoryService.toJGroupsAddress(address));
            }
            ((ChannelNodeFactory)this.factory.getValue()).invalidate(jgroupsAddresses);
        }
    }

    public CacheNodeFactory getValue() {
        return this;
    }

    private static org.jgroups.Address toJGroupsAddress(Address address) {
        if (address instanceof JGroupsAddress) {
            JGroupsAddress jgroupsAddress = (JGroupsAddress)address;
            return jgroupsAddress.getJGroupsAddress();
        }
        throw new IllegalArgumentException(address.toString());
    }
}

