/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.handle;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.enterprise.concurrent.ContextService;
import org.jboss.as.ee.EeLogger;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.concurrent.handle.ContextHandle;
import org.jboss.as.ee.concurrent.handle.ContextHandleFactory;
import org.jboss.as.server.deployment.SetupAction;

public class OtherEESetupActionsContextHandleFactory
implements ContextHandleFactory {
    public static final String NAME = "EE_SETUP_ACTIONS";
    private final List<SetupAction> setupActions;

    public OtherEESetupActionsContextHandleFactory(List<SetupAction> setupActions) {
        this.setupActions = setupActions;
    }

    @Override
    public ContextHandle saveContext(ContextService contextService, Map<String, String> contextObjectProperties) {
        return new OtherEESetupActionsContextHandle(this.setupActions);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getChainPriority() {
        return 400;
    }

    @Override
    public void writeHandle(ContextHandle contextHandle, ObjectOutputStream out) throws IOException {
    }

    @Override
    public ContextHandle readHandle(ObjectInputStream in) throws IOException, ClassNotFoundException {
        return new OtherEESetupActionsContextHandle(this.setupActions);
    }

    private static class OtherEESetupActionsContextHandle
    implements ContextHandle {
        private final List<SetupAction> setupActions;
        private LinkedList<SetupAction> resetActions;

        private OtherEESetupActionsContextHandle(List<SetupAction> setupActions) {
            this.setupActions = setupActions;
        }

        @Override
        public String getFactoryName() {
            return OtherEESetupActionsContextHandleFactory.NAME;
        }

        @Override
        public void setup() throws IllegalStateException {
            this.resetActions = new LinkedList();
            try {
                for (SetupAction setupAction : this.setupActions) {
                    setupAction.setup(Collections.emptyMap());
                    this.resetActions.addFirst(setupAction);
                }
            }
            catch (Error | RuntimeException e) {
                this.reset();
                throw e;
            }
        }

        @Override
        public void reset() {
            if (this.resetActions != null) {
                for (SetupAction resetAction : this.resetActions) {
                    try {
                        resetAction.teardown(Collections.emptyMap());
                    }
                    catch (Throwable e) {
                        EeLogger.ROOT_LOGGER.debug("failed to teardown action", e);
                    }
                }
                this.resetActions = null;
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw EeMessages.MESSAGES.serializationMustBeHandledByThefactory();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw EeMessages.MESSAGES.serializationMustBeHandledByThefactory();
        }
    }
}

