/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.remoting.transport.Address;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.web.infinispan.session.RouteRegistryEntryProvider;
import org.wildfly.clustering.web.infinispan.session.RouteRegistryEntryProviderService;
import org.wildfly.clustering.web.session.RouteLocator;

public class RouteLocatorService
extends AbstractService<RouteLocator>
implements RouteLocator {
    public static final ServiceName REGISTRY_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"clustering", "registry", "web", "default"});
    public static final ServiceName NODE_FACTORY_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"clustering", "nodes", "web", "default", "entry"});
    private final InjectedValue<NodeFactory<Address>> nodeFactory = new InjectedValue();
    private final InjectedValue<Registry<String, Void>> registry = new InjectedValue();
    private final InjectedValue<RouteRegistryEntryProvider> provider = new InjectedValue();
    private final InjectedValue<Cache<String, ?>> cache = new InjectedValue();

    public static ServiceBuilder<RouteLocator> build(ServiceTarget target, ServiceName name, String deploymentName) {
        RouteLocatorService service = new RouteLocatorService();
        return target.addService(name, (Service)service).addDependency(ServiceBuilder.DependencyType.OPTIONAL, NODE_FACTORY_SERVICE_NAME, NodeFactory.class, service.nodeFactory).addDependency(ServiceBuilder.DependencyType.OPTIONAL, REGISTRY_SERVICE_NAME, Registry.class, service.registry).addDependency(RouteRegistryEntryProviderService.SERVICE_NAME, RouteRegistryEntryProvider.class, service.provider).addDependency(RouteLocatorService.getCacheServiceAlias(deploymentName), Cache.class, service.cache);
    }

    public static ServiceName getCacheServiceAlias(String deploymentName) {
        return ServiceName.JBOSS.append(new String[]{"clustering", "web", "locator", deploymentName});
    }

    private RouteLocatorService() {
    }

    public RouteLocator getValue() {
        return this;
    }

    public String locate(String sessionId) {
        NodeFactory nodeFactory;
        Registry registry = (Registry)this.registry.getOptionalValue();
        if (registry == null) {
            return ((RouteRegistryEntryProvider)this.provider.getValue()).getKey();
        }
        Map.Entry entry = null;
        Address location = this.locatePrimaryOwner(sessionId);
        if (location != null && (nodeFactory = (NodeFactory)this.nodeFactory.getOptionalValue()) != null) {
            Node node = nodeFactory.createNode((Object)location);
            entry = registry.getEntry(node);
        }
        if (entry == null) {
            entry = registry.getLocalEntry();
        }
        return entry != null ? (String)entry.getKey() : null;
    }

    private Address locatePrimaryOwner(String sessionId) {
        Cache cache = (Cache)this.cache.getValue();
        DistributionManager dist = cache.getAdvancedCache().getDistributionManager();
        return dist != null ? dist.getPrimaryLocation((Object)sessionId) : cache.getCacheManager().getAddress();
    }
}

