/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.util.Map;
import java.util.Set;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.idm.model.AttributedType;

public class LDAPMappingConfiguration {
    private final Class<? extends AttributedType> mappedClass;
    private final Set<String> objectClasses;
    private final String baseDN;
    private final Map<String, String> mappedProperties;
    private final Property<String> idProperty;
    private final Class<? extends AttributedType> relatedAttributedType;
    private final String parentMembershipAttributeName;
    private final Map<String, String> parentMapping;
    private final Set<String> readOnlyAttributes;
    private final int hierarchySearchDepth;

    LDAPMappingConfiguration(Class<? extends AttributedType> mappedClass, Set<String> objectClasses, String baseDN, String idPropertyName, Map<String, String> mappedProperties, Set<String> readOnlyAttributes, Map<String, String> parentMapping, Class<? extends AttributedType> relatedAttributedType, String parentMembershipAttributeName, int hierarchySearchDepth) {
        this.mappedClass = mappedClass;
        this.objectClasses = objectClasses;
        this.baseDN = baseDN;
        this.mappedProperties = mappedProperties;
        this.readOnlyAttributes = readOnlyAttributes;
        this.parentMapping = parentMapping;
        this.hierarchySearchDepth = hierarchySearchDepth;
        this.idProperty = idPropertyName != null ? PropertyQueries.createQuery(this.getMappedClass()).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{idPropertyName})).getFirstResult() : null;
        this.relatedAttributedType = relatedAttributedType;
        this.parentMembershipAttributeName = parentMembershipAttributeName;
    }

    public Class<? extends AttributedType> getMappedClass() {
        return this.mappedClass;
    }

    public Set<String> getObjectClasses() {
        return this.objectClasses;
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public Map<String, String> getMappedProperties() {
        return this.mappedProperties;
    }

    public Property<String> getIdProperty() {
        return this.idProperty;
    }

    public Class<? extends AttributedType> getRelatedAttributedType() {
        return this.relatedAttributedType;
    }

    public String getParentMembershipAttributeName() {
        return this.parentMembershipAttributeName;
    }

    public Map<String, String> getParentMapping() {
        return this.parentMapping;
    }

    public Set<String> getReadOnlyAttributes() {
        return this.readOnlyAttributes;
    }

    public int getHierarchySearchDepth() {
        return this.hierarchySearchDepth;
    }
}

