/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.naming.namemanager;

import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jacorb.naming.namemanager.NSTree;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPProfile;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class ContextNode {
    protected Binding[] contents;
    public boolean matched;
    public boolean used = false;
    public NamingContextExt context;
    private DefaultMutableTreeNode myDefaultNode;
    private DefaultTreeModel model;
    private Binding binding;
    private Vector bindingData;
    private String myName;

    public ContextNode(NamingContextExt context, DefaultTreeModel model) {
        this.model = model;
        this.context = context;
    }

    public ContextNode(NamingContextExt context, Binding b, DefaultTreeModel model) {
        this.model = model;
        this.context = context;
        this.binding = b;
    }

    public void display() {
        this.update();
        if (this.bindingData != null) {
            NSTree.nsTable.setData(this.bindingData, this);
        }
    }

    public boolean equals(ContextNode bnode) {
        return this.toString().equals(bnode.toString());
    }

    public NameComponent[] getName() {
        return this.binding.binding_name;
    }

    public void setNode(DefaultMutableTreeNode node) {
        this.myDefaultNode = node;
    }

    public String toString() {
        if (this.binding == null) {
            return "RootContext";
        }
        if (this.myName == null) {
            NameComponent[] name = this.binding.binding_name;
            String kind = name[name.length - 1].kind;
            this.myName = name[name.length - 1].id + (kind != null && kind.length() > 0 ? "." + kind : "");
        }
        return this.myName;
    }

    public void unbind(NameComponent[] nc) throws NotFound, CannotProceed, InvalidName {
        this.context.unbind(nc);
    }

    public synchronized void update() {
        try {
            Vector row;
            ParsedIOR pior;
            NameComponent[] ncs;
            NameComponent last;
            int i;
            ContextNode context_node;
            int i2;
            BindingListHolder blsoh = new BindingListHolder();
            BindingIteratorHolder bioh = new BindingIteratorHolder();
            this.context.list(40, blsoh, bioh);
            Binding[] bindings = blsoh.value;
            int childCount = this.myDefaultNode.getChildCount();
            int context_count = 0;
            int object_count = 0;
            for (int i3 = 0; i3 < bindings.length; ++i3) {
                if (bindings[i3].binding_type == BindingType.ncontext) {
                    ++context_count;
                    continue;
                }
                ++object_count;
            }
            ContextNode[] contexts = new ContextNode[context_count];
            Binding[] objects = new Binding[object_count];
            for (i2 = 0; i2 < bindings.length; ++i2) {
                if (bindings[i2].binding_type == BindingType.ncontext) {
                    contexts[--context_count] = new ContextNode(NamingContextExtHelper.narrow(this.context.resolve(bindings[i2].binding_name)), bindings[i2], this.model);
                    continue;
                }
                objects[--object_count] = bindings[i2];
            }
            for (i2 = 0; i2 < childCount; ++i2) {
                DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)this.myDefaultNode.getChildAt(i2);
                context_node = (ContextNode)dmtn.getUserObject();
                for (int j = 0; j < contexts.length; ++j) {
                    if (!context_node.equals(contexts[j])) continue;
                    context_node.matched = true;
                    contexts[j].matched = true;
                }
            }
            Vector<DefaultMutableTreeNode> removeList = new Vector<DefaultMutableTreeNode>();
            for (int i4 = 0; i4 < childCount; ++i4) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.myDefaultNode.getChildAt(i4);
                context_node = (ContextNode)node.getUserObject();
                if (!context_node.matched) {
                    removeList.addElement(node);
                    continue;
                }
                context_node.matched = false;
            }
            int rsize = removeList.size();
            for (i = 0; i < rsize; ++i) {
                this.model.removeNodeFromParent((DefaultMutableTreeNode)removeList.elementAt(i));
            }
            this.bindingData = new Vector();
            for (i = 0; i < contexts.length; ++i) {
                if (!contexts[i].matched) {
                    contexts[i].used = true;
                    DefaultMutableTreeNode node = new DefaultMutableTreeNode();
                    contexts[i].setNode(node);
                    node.setUserObject(contexts[i]);
                    node.setAllowsChildren(true);
                    this.model.insertNodeInto(node, this.myDefaultNode, 0);
                }
                last = contexts[i].binding.binding_name[contexts[i].binding.binding_name.length - 1];
                ncs = new NameComponent[]{last};
                pior = null;
                try {
                    pior = ((Delegate)((ObjectImpl)this.context.resolve(ncs))._get_delegate()).getParsedIOR();
                }
                catch (NotFound nf) {
                    continue;
                }
                row = this.createRow(last, pior);
                this.bindingData.addElement(row);
            }
            for (i = 0; i < objects.length; ++i) {
                last = objects[i].binding_name[objects[i].binding_name.length - 1];
                ncs = new NameComponent[]{last};
                pior = null;
                try {
                    pior = ((Delegate)((ObjectImpl)this.context.resolve(ncs))._get_delegate()).getParsedIOR();
                }
                catch (NotFound nf) {
                    continue;
                }
                row = this.createRow(last, pior);
                this.bindingData.addElement(row);
            }
            childCount = this.myDefaultNode.getChildCount();
            for (i = 0; i < childCount; ++i) {
                DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)this.myDefaultNode.getChildAt(i);
                context_node = (ContextNode)dmtn.getUserObject();
                context_node.update();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Vector createRow(NameComponent last, ParsedIOR pior) {
        Vector<String> row = new Vector<String>();
        row.addElement(last.id);
        row.addElement(last.kind);
        row.addElement(pior.getTypeId());
        IIOPProfile p = (IIOPProfile)pior.getEffectiveProfile();
        IIOPAddress iiopAddress = (IIOPAddress)p.getAddress();
        row.addElement(iiopAddress.getIP());
        row.addElement(Integer.toString(iiopAddress.getPort()));
        return row;
    }
}

