/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.spnego;

import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.acl.Group;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;
import org.jboss.security.SimpleGroup;
import org.jboss.security.negotiation.Constants;
import org.jboss.security.negotiation.NegotiationMessage;
import org.jboss.security.negotiation.common.CommonLoginModule;
import org.jboss.security.negotiation.common.NegotiationContext;
import org.jboss.security.negotiation.spnego.KerberosMessage;
import org.jboss.security.negotiation.spnego.encoding.NegTokenInit;
import org.jboss.security.negotiation.spnego.encoding.NegTokenTarg;
import org.jboss.security.negotiation.spnego.encoding.SPNEGOMessage;

public class SPNEGOLoginModule
extends CommonLoginModule {
    private static final String REMOVE_REALM_FROM_PRINCIPAL = "removeRealmFromPrincipal";
    private static final String SERVER_SECURITY_DOMAIN = "serverSecurityDomain";
    private static final String USERNAME_PASSWORD_DOMAIN = "usernamePasswordDomain";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"removeRealmFromPrincipal", "serverSecurityDomain", "usernamePasswordDomain"};
    private static final String SPNEGO = "SPNEGO";
    private static final Oid kerberos = Constants.KERBEROS_V5;
    private boolean removeRealmFromPrincipal;
    private String serverSecurityDomain;
    private String usernamePasswordDomain;
    private LoginContext serverLoginContext = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.addValidOptions(ALL_VALID_OPTIONS);
        super.initialize(subject, callbackHandler, sharedState, options);
        this.serverSecurityDomain = (String)options.get(SERVER_SECURITY_DOMAIN);
        this.usernamePasswordDomain = (String)options.get(USERNAME_PASSWORD_DOMAIN);
        String temp = (String)options.get(REMOVE_REALM_FROM_PRINCIPAL);
        this.removeRealmFromPrincipal = Boolean.valueOf(temp);
        if (!this.removeRealmFromPrincipal && this.principalClassName == null) {
            this.principalClassName = KerberosPrincipal.class.getName();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("removeRealmFromPrincipal=" + this.removeRealmFromPrincipal));
            this.log.debug((Object)("serverSecurityDomain=" + this.serverSecurityDomain));
            this.log.debug((Object)("usernamePasswordDomain=" + this.usernamePasswordDomain));
        }
    }

    public boolean login() throws LoginException {
        boolean TRACE = this.log.isTraceEnabled();
        if (super.login()) {
            this.log.debug((Object)"super.login()==true");
            return true;
        }
        this.loginOk = false;
        Object result = this.innerLogin();
        if (TRACE) {
            this.log.trace((Object)("Result - " + result));
        }
        if (result instanceof Boolean) {
            if (Boolean.TRUE.equals(result)) {
                this.loginOk = true;
                if (this.getUseFirstPass()) {
                    Principal identity = this.getIdentity();
                    String userName = identity.getName();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Storing username '" + userName + "' and empty password"));
                    }
                    this.sharedState.put("javax.security.auth.login.name", identity);
                    this.sharedState.put("javax.security.auth.login.password", "");
                }
            }
        } else if (result instanceof Exception) {
            Exception e = (Exception)result;
            this.log.error((Object)"Unable to authenticate", (Throwable)e);
            throw new LoginException("Unable to authenticate - " + e.getMessage());
        }
        if (TRACE) {
            this.log.trace((Object)("super.loginOk " + this.loginOk));
        }
        if (this.loginOk) {
            return true;
        }
        throw new LoginException("Continuation Required.");
    }

    protected Object innerLogin() throws LoginException {
        NegotiationContext negotiationContext = NegotiationContext.getCurrentNegotiationContext();
        if (negotiationContext == null) {
            if (this.usernamePasswordDomain == null) {
                throw new LoginException("No NegotiationContext and no usernamePasswordDomain defined.");
            }
            return this.usernamePasswordLogin();
        }
        return this.spnegoLogin(negotiationContext);
    }

    private Object usernamePasswordLogin() throws LoginException {
        this.log.debug((Object)"Falling back to username/password authentication");
        LoginContext lc = new LoginContext(this.usernamePasswordDomain, this.callbackHandler);
        lc.login();
        Subject userSubject = lc.getSubject();
        Principal identity = this.getIdentityFromSubject(userSubject);
        this.setIdentity(identity);
        return Boolean.TRUE;
    }

    protected Principal getIdentityFromSubject(Subject userSubject) throws LoginException {
        Set<Principal> principals = userSubject.getPrincipals();
        if (principals.isEmpty()) {
            throw new LoginException("No principal returned after login.");
        }
        if (principals.size() > 1) {
            this.log.warn((Object)"Multiple principals returned, using first principal in set.");
        }
        Principal identity = principals.iterator().next();
        return identity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object spnegoLogin(NegotiationContext negotiationContext) throws LoginException {
        NegotiationMessage requestMessage = negotiationContext.getRequestMessage();
        if (!(requestMessage instanceof SPNEGOMessage) && !(requestMessage instanceof KerberosMessage)) {
            String message = "Unsupported negotiation mechanism '" + requestMessage.getMessageType() + "'.";
            this.log.warn((Object)message);
            throw new LoginException(message);
        }
        try {
            Object result;
            Subject server = this.getServerSubject();
            AcceptSecContext action = new AcceptSecContext(negotiationContext);
            Object t = result = Subject.doAs(server, action);
            return t;
        }
        finally {
            if (this.serverLoginContext != null) {
                this.serverLoginContext.logout();
            }
        }
    }

    protected Principal createIdentity(String username) throws Exception {
        if (this.removeRealmFromPrincipal) {
            return super.createIdentity(username.substring(0, username.indexOf("@")));
        }
        return super.createIdentity(username);
    }

    protected Group[] getRoleSets() throws LoginException {
        SimpleGroup roles = new SimpleGroup("Roles");
        SimpleGroup callerPrincipal = new SimpleGroup("CallerPrincipal");
        Group[] groups = new Group[]{roles, callerPrincipal};
        callerPrincipal.addMember(this.getIdentity());
        return groups;
    }

    protected Subject getServerSubject() throws LoginException {
        LoginContext lc = new LoginContext(this.serverSecurityDomain);
        lc.login();
        this.serverLoginContext = lc;
        Subject serverSubject = this.serverLoginContext.getSubject();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Subject = " + serverSubject));
            this.log.debug((Object)("Logged in '" + this.serverSecurityDomain + "' LoginContext"));
        }
        return serverSubject;
    }

    private class AcceptSecContext
    implements PrivilegedAction {
        private final NegotiationContext negotiationContext;
        private boolean DEBUG;

        public AcceptSecContext(NegotiationContext negotiationContext) {
            this.DEBUG = SPNEGOLoginModule.this.log.isDebugEnabled();
            this.negotiationContext = negotiationContext;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object run() {
            try {
                byte[] gssToken;
                NegotiationMessage requestMessage;
                block18: {
                    requestMessage = this.negotiationContext.getRequestMessage();
                    gssToken = null;
                    if (requestMessage instanceof NegTokenInit) {
                        NegTokenInit negTokenInit = (NegTokenInit)requestMessage;
                        List<Oid> mechList = negTokenInit.getMechTypes();
                        if (mechList.get(0).equals(kerberos)) {
                            gssToken = negTokenInit.getMechToken();
                            break block18;
                        } else {
                            boolean kerberosSupported = false;
                            Iterator<Oid> it = mechList.iterator();
                            while (it.hasNext() && !kerberosSupported) {
                                kerberosSupported = it.next().equals(kerberos);
                            }
                            NegTokenTarg negTokenTarg = new NegTokenTarg();
                            if (kerberosSupported) {
                                negTokenTarg.setNegResult(NegTokenTarg.ACCEPT_INCOMPLETE);
                                negTokenTarg.setSupportedMech(kerberos);
                            } else {
                                negTokenTarg.setNegResult(NegTokenTarg.REJECTED);
                            }
                            this.negotiationContext.setResponseMessage((NegotiationMessage)negTokenTarg);
                            return Boolean.FALSE;
                        }
                    }
                    if (requestMessage instanceof NegTokenTarg) {
                        NegTokenTarg negTokenTarg = (NegTokenTarg)requestMessage;
                        gssToken = negTokenTarg.getResponseToken();
                    } else if (requestMessage instanceof KerberosMessage) {
                        KerberosMessage kerberosMessage = (KerberosMessage)requestMessage;
                        gssToken = kerberosMessage.getToken();
                    }
                }
                Object schemeContext = this.negotiationContext.getSchemeContext();
                if (schemeContext != null && !(schemeContext instanceof GSSContext)) {
                    throw new IllegalStateException("The schemeContext is not a GSSContext");
                }
                GSSContext gssContext = (GSSContext)schemeContext;
                if (gssContext == null) {
                    SPNEGOLoginModule.this.log.debug((Object)"Creating new GSSContext.");
                    GSSManager manager = GSSManager.getInstance();
                    gssContext = manager.createContext((GSSCredential)null);
                    this.negotiationContext.setSchemeContext((Object)gssContext);
                }
                if (gssContext.isEstablished()) {
                    SPNEGOLoginModule.this.log.warn((Object)"Authentication was performed despite already being authenticated!");
                    this.processIdentity(gssContext);
                    return Boolean.TRUE;
                }
                byte[] respToken = gssContext.acceptSecContext(gssToken, 0, gssToken.length);
                if (respToken != null) {
                    NegotiationMessage response;
                    if (requestMessage instanceof KerberosMessage) {
                        response = new KerberosMessage(Constants.KERBEROS_V5, respToken);
                    } else {
                        NegTokenTarg negTokenTarg = new NegTokenTarg();
                        negTokenTarg.setResponseToken(respToken);
                        response = negTokenTarg;
                    }
                    this.negotiationContext.setResponseMessage(response);
                }
                if (!gssContext.isEstablished()) {
                    return Boolean.FALSE;
                }
                this.processIdentity(gssContext);
                return Boolean.TRUE;
            }
            catch (Exception e) {
                return e;
            }
        }

        private void processIdentity(GSSContext gssContext) throws GSSException, Exception {
            SPNEGOLoginModule.this.setIdentity(SPNEGOLoginModule.this.createIdentity(((Object)gssContext.getSrcName()).toString()));
            if (this.DEBUG) {
                SPNEGOLoginModule.this.log.debug((Object)("context.getCredDelegState() = " + gssContext.getCredDelegState()));
                SPNEGOLoginModule.this.log.debug((Object)("context.getMutualAuthState() = " + gssContext.getMutualAuthState()));
                SPNEGOLoginModule.this.log.debug((Object)("context.getSrcName() = " + ((Object)gssContext.getSrcName()).toString()));
            }
            this.negotiationContext.setAuthenticationMethod(SPNEGOLoginModule.SPNEGO);
            this.negotiationContext.setAuthenticated(true);
        }
    }
}

