/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.util;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.validator.ValidateException;

public class ModelNodeUtil {
    public static Long getLongIfSetOrGetDefault(OperationContext context, ModelNode dataSourceNode, SimpleAttributeDefinition key) throws OperationFailedException {
        ModelNode resolvedNode = key.resolveModelAttribute(context, dataSourceNode);
        return resolvedNode.isDefined() ? Long.valueOf(resolvedNode.asLong()) : null;
    }

    public static Integer getIntIfSetOrGetDefault(OperationContext context, ModelNode dataSourceNode, SimpleAttributeDefinition key) throws OperationFailedException {
        ModelNode resolvedNode = key.resolveModelAttribute(context, dataSourceNode);
        return resolvedNode.isDefined() ? Integer.valueOf(resolvedNode.asInt()) : null;
    }

    public static Boolean getBooleanIfSetOrGetDefault(OperationContext context, ModelNode dataSourceNode, SimpleAttributeDefinition key) throws OperationFailedException {
        ModelNode resolvedNode = key.resolveModelAttribute(context, dataSourceNode);
        return resolvedNode.isDefined() ? Boolean.valueOf(resolvedNode.asBoolean()) : null;
    }

    public static String getResolvedStringIfSetOrGetDefault(OperationContext context, ModelNode dataSourceNode, SimpleAttributeDefinition key) throws OperationFailedException {
        String resolvedString;
        ModelNode resolvedNode = key.resolveModelAttribute(context, dataSourceNode);
        String string = resolvedString = resolvedNode.isDefined() ? resolvedNode.asString() : null;
        if (resolvedString != null && resolvedString.trim().length() == 0) {
            resolvedString = null;
        }
        return resolvedString;
    }

    public static Extension extractExtension(OperationContext operationContext, ModelNode dataSourceNode, SimpleAttributeDefinition className, PropertiesAttributeDefinition propertyName) throws ValidateException, OperationFailedException {
        if (dataSourceNode.hasDefined(className.getName())) {
            String exceptionSorterClassName = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, className);
            Map unwrapped = propertyName.unwrap(operationContext, dataSourceNode);
            Map exceptionSorterProperty = unwrapped.size() > 0 ? unwrapped : null;
            return new Extension(exceptionSorterClassName, exceptionSorterProperty);
        }
        return null;
    }

    public static Map<String, String> extractMap(ModelNode operation, ObjectListAttributeDefinition objList, SimpleAttributeDefinition keyAttribute, SimpleAttributeDefinition valueAttribute) {
        HashMap<String, String> returnMap = null;
        if (operation.hasDefined(objList.getName())) {
            returnMap = new HashMap<String, String>(operation.get(objList.getName()).asList().size());
            for (ModelNode node : operation.get(objList.getName()).asList()) {
                returnMap.put(node.asObject().get(keyAttribute.getName()).asString(), node.asObject().get(valueAttribute.getName()).asString());
            }
        }
        return returnMap;
    }
}

