/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.messagedriven;

import java.util.Properties;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.component.EJBComponentCreateService;
import org.jboss.as.ejb3.component.EJBUtilities;
import org.jboss.as.ejb3.component.messagedriven.DefaultResourceAdapterService;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponent;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentDescription;
import org.jboss.as.ejb3.component.pool.PoolConfig;
import org.jboss.as.ejb3.deployment.ApplicationExceptions;
import org.jboss.as.ejb3.inflow.EndpointDeployer;
import org.jboss.jca.core.spi.rar.Endpoint;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;

public class MessageDrivenComponentCreateService
extends EJBComponentCreateService {
    private final Class<?> messageListenerInterface;
    private final Properties activationProps;
    private final String resourceAdapterName;
    private final boolean deliveryActive;
    private final InjectedValue<ResourceAdapter> resourceAdapterInjectedValue = new InjectedValue();
    private final InjectedValue<PoolConfig> poolConfig = new InjectedValue();
    private final InjectedValue<DefaultResourceAdapterService> defaultResourceAdapterServiceInjectedValue = new InjectedValue();
    private final InjectedValue<EJBUtilities> ejbUtilitiesInjectedValue = new InjectedValue();
    private final ClassLoader moduleClassLoader;

    public MessageDrivenComponentCreateService(ComponentConfiguration componentConfiguration, ApplicationExceptions ejbJarConfiguration, Class<?> messageListenerInterface) {
        super(componentConfiguration, ejbJarConfiguration);
        MessageDrivenComponentDescription componentDescription = (MessageDrivenComponentDescription)componentConfiguration.getComponentDescription();
        this.resourceAdapterName = componentDescription.getResourceAdapterName();
        this.deliveryActive = componentDescription.isDeliveryActive();
        this.messageListenerInterface = messageListenerInterface;
        this.activationProps = componentDescription.getActivationProps();
        this.moduleClassLoader = componentConfiguration.getModuleClassLoader();
    }

    public void start(StartContext context) throws StartException {
        super.start(context);
        EjbLogger.ROOT_LOGGER.logMDBStart(this.getComponentName(), this.resourceAdapterName);
    }

    protected BasicComponent createComponent() {
        String configuredResourceAdapterName = this.resourceAdapterName == null ? ((DefaultResourceAdapterService)this.defaultResourceAdapterServiceInjectedValue.getValue()).getDefaultResourceAdapterName() : this.resourceAdapterName;
        String activeResourceAdapterName = this.searchActiveResourceAdapterName(configuredResourceAdapterName);
        ActivationSpec activationSpec = this.getEndpointDeployer().createActivationSpecs(activeResourceAdapterName, this.messageListenerInterface, this.activationProps, this.getDeploymentClassLoader());
        MessageDrivenComponent component = new MessageDrivenComponent(this, this.messageListenerInterface, activationSpec, this.deliveryActive);
        ResourceAdapter resourceAdapter = (ResourceAdapter)this.resourceAdapterInjectedValue.getValue();
        component.setResourceAdapter(resourceAdapter);
        EJBUtilities ejbUtilities = (EJBUtilities)this.ejbUtilitiesInjectedValue.getValue();
        Endpoint endpoint = ejbUtilities.getEndpoint(activeResourceAdapterName);
        component.setEndpoint(endpoint);
        return component;
    }

    private String searchActiveResourceAdapterName(String configuredResourceAdapterName) {
        String result = configuredResourceAdapterName;
        if (ConnectorServices.getRegisteredResourceAdapterIdentifier((String)configuredResourceAdapterName) == null) {
            String amended = this.stripDotRarSuffix(configuredResourceAdapterName);
            if (configuredResourceAdapterName.equals(amended)) {
                amended = configuredResourceAdapterName + ".rar";
            }
            if (ConnectorServices.getRegisteredResourceAdapterIdentifier((String)amended) != null) {
                result = amended;
            }
        }
        return result;
    }

    Injector<DefaultResourceAdapterService> getDefaultResourceAdapterServiceInjector() {
        return this.defaultResourceAdapterServiceInjectedValue;
    }

    PoolConfig getPoolConfig() {
        return (PoolConfig)this.poolConfig.getOptionalValue();
    }

    public InjectedValue<PoolConfig> getPoolConfigInjector() {
        return this.poolConfig;
    }

    private ClassLoader getDeploymentClassLoader() {
        return this.getComponentClass().getClassLoader();
    }

    private EndpointDeployer getEndpointDeployer() {
        return this.getEJBUtilities();
    }

    public InjectedValue<ResourceAdapter> getResourceAdapterInjector() {
        return this.resourceAdapterInjectedValue;
    }

    public Injector<EJBUtilities> getEJBUtilitiesInjector() {
        return this.ejbUtilitiesInjectedValue;
    }

    public ClassLoader getModuleClassLoader() {
        return this.moduleClassLoader;
    }

    private String stripDotRarSuffix(String raName) {
        if (raName == null) {
            return null;
        }
        if (raName.endsWith(".rar")) {
            return raName.substring(0, raName.indexOf(".rar"));
        }
        return raName;
    }
}

