/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.cacheloader.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.lucene.cacheloader.configuration.LuceneLoaderConfiguration;

public class LuceneLoaderConfigurationBuilder
extends AbstractStoreConfigurationBuilder<LuceneLoaderConfiguration, LuceneLoaderConfigurationBuilder> {
    private int autoChunkSize = 0x1FFFFFF;
    private String location = "Infinispan-IndexStore";

    public LuceneLoaderConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder);
    }

    public LuceneLoaderConfigurationBuilder autoChunkSize(int autoChunkSize) {
        this.autoChunkSize = autoChunkSize;
        return this;
    }

    public LuceneLoaderConfigurationBuilder location(String location) {
        this.location = location;
        return this;
    }

    public void validate() {
    }

    public LuceneLoaderConfiguration create() {
        return new LuceneLoaderConfiguration(this.purgeOnStartup, this.fetchPersistentState, this.ignoreModifications, this.async.create(), this.singleton().create(), this.preload, this.shared, this.properties, this.autoChunkSize, this.location);
    }

    public Builder<?> read(LuceneLoaderConfiguration template) {
        this.autoChunkSize = template.autoChunkSize();
        this.location = template.location();
        this.fetchPersistentState = template.fetchPersistentState();
        this.ignoreModifications = template.ignoreModifications();
        this.properties = template.properties();
        this.purgeOnStartup = template.purgeOnStartup();
        this.async.read(template.async());
        this.singletonStore.read(template.singletonStore());
        this.preload = template.preload();
        return this;
    }

    public LuceneLoaderConfigurationBuilder self() {
        return this;
    }

    public String toString() {
        return "LuceneLoaderConfigurationBuilder{autoChunkSize=" + this.autoChunkSize + ", " + "location=" + this.location + "}";
    }
}

