/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.impl;

import org.infinispan.query.dsl.FilterConditionBeginContext;
import org.infinispan.query.dsl.FilterConditionContext;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.impl.AndCondition;
import org.infinispan.query.dsl.impl.BooleanCondition;
import org.infinispan.query.dsl.impl.IncompleteCondition;
import org.infinispan.query.dsl.impl.OrCondition;
import org.infinispan.query.dsl.impl.Visitable;

abstract class BaseCondition
implements FilterConditionContext,
Visitable {
    protected BaseCondition parent = null;
    protected QueryBuilder queryBuilder;

    protected BaseCondition() {
    }

    @Override
    public <T extends Query> QueryBuilder<T> toBuilder() {
        if (this.queryBuilder == null) {
            throw new IllegalStateException("This sub-query does not belong to a parent query builder yet");
        }
        return this.queryBuilder;
    }

    void setQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    public BaseCondition getRoot() {
        BaseCondition p = this;
        while (p.getParent() != null) {
            p = p.getParent();
        }
        return p;
    }

    public BaseCondition getParent() {
        return this.parent;
    }

    public void setParent(BaseCondition parent) {
        this.parent = parent;
    }

    @Override
    public FilterConditionBeginContext and() {
        IncompleteCondition rightCondition = new IncompleteCondition();
        this.combine(true, rightCondition);
        return rightCondition;
    }

    @Override
    public FilterConditionContext and(FilterConditionContext rightCondition) {
        this.combine(true, rightCondition);
        return this;
    }

    @Override
    public FilterConditionBeginContext or() {
        IncompleteCondition rightCondition = new IncompleteCondition();
        this.combine(false, rightCondition);
        return rightCondition;
    }

    @Override
    public FilterConditionContext or(FilterConditionContext rightCondition) {
        this.combine(false, rightCondition);
        return this;
    }

    private void combine(boolean isConjunction, FilterConditionContext fcc) {
        BaseCondition rightCondition = ((BaseCondition)fcc).getRoot();
        if (isConjunction && this.parent instanceof OrCondition) {
            AndCondition p = new AndCondition(this, rightCondition);
            ((BooleanCondition)this.parent).replaceChildCondition(this, p);
            this.parent = p;
            rightCondition.setParent(p);
        } else {
            BaseCondition root = this.getRoot();
            BooleanCondition p = isConjunction ? new AndCondition(root, rightCondition) : new OrCondition(root, rightCondition);
            root.setParent(p);
            rightCondition.setParent(p);
        }
        rightCondition.setQueryBuilder(this.queryBuilder);
    }
}

