/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.as.clustering.concurrent.Scheduler;
import org.jboss.as.clustering.infinispan.invoker.Remover;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.clustering.web.Batch;
import org.wildfly.clustering.web.Batcher;
import org.wildfly.clustering.web.infinispan.InfinispanWebLogger;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.security.manager.action.GetAccessControlContextAction;

public class SessionExpirationScheduler
implements Scheduler<ImmutableSession> {
    final Map<String, Future<?>> expirationFutures = new ConcurrentHashMap();
    final Batcher batcher;
    final Remover<String> remover;
    private final ScheduledExecutorService executor;

    public SessionExpirationScheduler(Batcher batcher, Remover<String> remover) {
        this(batcher, remover, SessionExpirationScheduler.createScheduledExecutor(SessionExpirationScheduler.createThreadFactory()));
    }

    private static ThreadFactory createThreadFactory() {
        return new JBossThreadFactory(new ThreadGroup(SessionExpirationScheduler.class.getSimpleName()), Boolean.FALSE, null, "%G - %t", null, null, (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance()));
    }

    private static ScheduledExecutorService createScheduledExecutor(ThreadFactory factory) {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, factory);
        executor.setRemoveOnCancelPolicy(true);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        return executor;
    }

    public SessionExpirationScheduler(Batcher batcher, Remover<String> remover, ScheduledExecutorService executor) {
        this.batcher = batcher;
        this.remover = remover;
        this.executor = executor;
    }

    public void cancel(ImmutableSession session) {
        Future<?> future = this.expirationFutures.remove(session.getId());
        if (future != null) {
            future.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(ImmutableSession session) {
        long timeout = session.getMetaData().getMaxInactiveInterval(TimeUnit.MILLISECONDS);
        if (timeout > 0L) {
            ExpirationTask task;
            String id = session.getId();
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s will expire in %d ms", id, timeout);
            ExpirationTask expirationTask = task = new ExpirationTask(id);
            synchronized (expirationTask) {
                this.expirationFutures.put(id, this.executor.schedule(task, timeout, TimeUnit.MILLISECONDS));
            }
        }
    }

    public void close() {
        this.executor.shutdown();
        for (Future<?> future : this.expirationFutures.values()) {
            future.cancel(false);
        }
        for (Future<?> future : this.expirationFutures.values()) {
            if (future.isDone()) continue;
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {}
        }
        this.expirationFutures.clear();
    }

    private class ExpirationTask
    implements Runnable {
        private final String id;

        public ExpirationTask(String id) {
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InfinispanWebLogger.ROOT_LOGGER.tracef("Expiring session %s", this.id);
            try {
                Batch batch = SessionExpirationScheduler.this.batcher.startBatch();
                boolean success = false;
                try {
                    SessionExpirationScheduler.this.remover.remove((Object)this.id);
                    success = true;
                }
                finally {
                    if (success) {
                        batch.close();
                    } else {
                        batch.discard();
                    }
                }
            }
            finally {
                ExpirationTask expirationTask = this;
                synchronized (expirationTask) {
                    SessionExpirationScheduler.this.expirationFutures.remove(this.id);
                }
            }
        }
    }
}

