/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.ejb.client.ClusterContext;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.remoting.ChannelAssociation;
import org.jboss.ejb.client.remoting.PackedInteger;
import org.jboss.ejb.client.remoting.ProtocolMessageHandler;
import org.jboss.logging.Logger;

class ClusterNodeRemovalHandler
extends ProtocolMessageHandler {
    private static final Logger logger = Logger.getLogger(ClusterNodeRemovalHandler.class);
    private final ChannelAssociation channelAssociation;

    ClusterNodeRemovalHandler(ChannelAssociation channelAssociation) {
        this.channelAssociation = channelAssociation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processMessage(InputStream inputStream) throws IOException {
        Collection removedNodes;
        if (inputStream == null) {
            throw new IllegalArgumentException("Cannot read from null stream");
        }
        HashMap removedNodesPerCluster = new HashMap();
        try {
            DataInputStream input = new DataInputStream(inputStream);
            int clusterCount = PackedInteger.readPackedInteger(input);
            for (int i = 0; i < clusterCount; ++i) {
                String clusterName = input.readUTF();
                int clusterMemberCount = PackedInteger.readPackedInteger(input);
                removedNodes = new ArrayList<String>();
                for (int j = 0; j < clusterMemberCount; ++j) {
                    String nodeName = input.readUTF();
                    removedNodes.add(nodeName);
                }
                removedNodesPerCluster.put(clusterName, removedNodes);
            }
        }
        finally {
            inputStream.close();
        }
        EJBReceiverContext ejbReceiverContext = this.channelAssociation.getEjbReceiverContext();
        EJBClientContext clientContext = ejbReceiverContext.getClientContext();
        for (Map.Entry entry : removedNodesPerCluster.entrySet()) {
            String clusterName = (String)entry.getKey();
            removedNodes = (Collection)entry.getValue();
            logger.debug("Received a cluster node(s) removal message, for cluster named " + clusterName + " with " + removedNodes.size() + " removed nodes " + Arrays.toString(removedNodes.toArray()));
            ClusterContext clusterContext = clientContext.getClusterContext(clusterName);
            if (clusterContext == null) continue;
            for (String nodeName : removedNodes) {
                clusterContext.removeClusterNode(nodeName);
            }
        }
    }
}

