/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

public class FixedSizeBitSet {
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final long WORD_MASK = -1L;
    private final long[] words;
    private final int size;

    public FixedSizeBitSet(int size) {
        if (size < 0) {
            throw new NegativeArraySizeException("size < 0: " + size);
        }
        this.size = size;
        this.words = new long[FixedSizeBitSet.wordIndex(size - 1) + 1];
    }

    public boolean set(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        int wordIndex = FixedSizeBitSet.wordIndex(index);
        boolean already_set = (this.words[wordIndex] & 1L << index) != 0L;
        int n = wordIndex;
        this.words[n] = this.words[n] | 1L << index;
        return !already_set;
    }

    public void clear(int index) {
        int wordIndex;
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        int n = wordIndex = FixedSizeBitSet.wordIndex(index);
        this.words[n] = this.words[n] & (1L << index ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        int wordIndex = FixedSizeBitSet.wordIndex(index);
        return (this.words[wordIndex] & 1L << index) != 0L;
    }

    public int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex);
        }
        if (fromIndex >= this.size) {
            return -1;
        }
        int u = FixedSizeBitSet.wordIndex(fromIndex);
        long word = this.words[u] & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.words.length) {
                return -1;
            }
            word = this.words[u];
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    public int nextClearBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex);
        }
        if (fromIndex >= this.size) {
            return -1;
        }
        int u = FixedSizeBitSet.wordIndex(fromIndex);
        if (u >= this.words.length) {
            return fromIndex;
        }
        long word = (this.words[u] ^ 0xFFFFFFFFFFFFFFFFL) & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.words.length) {
                return -1;
            }
            word = this.words[u] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    public int cardinality() {
        int sum = 0;
        for (int i = 0; i < this.words.length; ++i) {
            sum += Long.bitCount(this.words[i]);
        }
        return sum;
    }

    public int size() {
        return this.size;
    }

    public void flip() {
        int fromIndex = 0;
        int toIndex = this.size();
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = FixedSizeBitSet.wordIndex(fromIndex);
        int endWordIndex = FixedSizeBitSet.wordIndex(toIndex - 1);
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            int n = startWordIndex;
            this.words[n] = this.words[n] ^ firstWordMask & lastWordMask;
        } else {
            int n = startWordIndex;
            this.words[n] = this.words[n] ^ firstWordMask;
            int i = startWordIndex + 1;
            while (i < endWordIndex) {
                int n2 = i++;
                this.words[n2] = this.words[n2] ^ 0xFFFFFFFFFFFFFFFFL;
            }
            int n3 = endWordIndex;
            this.words[n3] = this.words[n3] ^ lastWordMask;
        }
    }

    public String toString() {
        int numBits = this.words.length > 128 ? this.cardinality() : this.words.length * 64;
        StringBuilder b = new StringBuilder(6 * numBits + 2);
        b.append('{');
        int i = this.nextSetBit(0);
        if (i != -1) {
            b.append(i);
            i = this.nextSetBit(i + 1);
            while (i >= 0) {
                int endOfRun = this.nextClearBit(i);
                do {
                    b.append(", ").append(i);
                } while (++i < endOfRun);
                i = this.nextSetBit(i + 1);
            }
        }
        b.append('}');
        return b.toString();
    }

    private static int wordIndex(int bitIndex) {
        return bitIndex >> 6;
    }
}

