/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.List;
import org.infinispan.configuration.cache.StoreConfiguration;

public class PersistenceConfiguration {
    private final boolean passivation;
    private final List<StoreConfiguration> stores;

    PersistenceConfiguration(boolean passivation, List<StoreConfiguration> stores) {
        this.passivation = passivation;
        this.stores = stores;
    }

    public boolean passivation() {
        return this.passivation;
    }

    public List<StoreConfiguration> stores() {
        return this.stores;
    }

    public Boolean fetchPersistentState() {
        for (StoreConfiguration c : this.stores) {
            if (!c.fetchPersistentState()) continue;
            return true;
        }
        return false;
    }

    public Boolean preload() {
        for (StoreConfiguration c : this.stores) {
            if (!c.preload()) continue;
            return true;
        }
        return false;
    }

    public boolean usingStores() {
        return !this.stores.isEmpty();
    }

    public boolean usingAsyncStore() {
        for (StoreConfiguration c : this.stores) {
            if (!c.async().enabled()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "PersistenceConfiguration{persistence=" + this.stores + ", passivation=" + this.passivation + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistenceConfiguration that = (PersistenceConfiguration)o;
        if (this.passivation != that.passivation) {
            return false;
        }
        return !(this.stores != null ? !this.stores.equals(that.stores) : that.stores != null);
    }

    public int hashCode() {
        int result = this.passivation ? 1 : 0;
        result = 31 * result + (this.stores != null ? this.stores.hashCode() : 0);
        return result;
    }
}

