/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.ResourceBundle;
import org.jboss.as.controller.NotificationDefinition;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;

public class GlobalNotifications {
    private static final NotificationDefinition RESOURCE_ADDED = NotificationDefinition.Builder.create("resource-added", ControllerResolver.getResolver("global")).build();
    private static final NotificationDefinition RESOURCE_REMOVED = NotificationDefinition.Builder.create("resource-removed", ControllerResolver.getResolver("global")).build();
    public static final String OLD_VALUE = "old-value";
    public static final String NEW_VALUE = "new-value";
    private static final NotificationDefinition ATTRIBUTE_VALUE_WRITTEN = NotificationDefinition.Builder.create("attribute-value-written", ControllerResolver.getResolver("global")).setDataValueDescriptor(new NotificationDefinition.DataValueDescriptor(){

        @Override
        public ModelNode describe(ResourceBundle bundle2) {
            String prefix = "global.attribute-value-written.";
            ModelNode desc = new ModelNode();
            desc.get(new String[]{"name", "description"}).set(bundle2.getString(prefix + "name"));
            desc.get(new String[]{GlobalNotifications.OLD_VALUE, "description"}).set(bundle2.getString(prefix + GlobalNotifications.OLD_VALUE));
            desc.get(new String[]{GlobalNotifications.NEW_VALUE, "description"}).set(bundle2.getString(prefix + GlobalNotifications.NEW_VALUE));
            return desc;
        }
    }).build();

    public static void registerGlobalNotifications(ManagementResourceRegistration root, ProcessType processType) {
        root.registerNotification(RESOURCE_ADDED, true);
        root.registerNotification(RESOURCE_REMOVED, true);
        if (processType != ProcessType.DOMAIN_SERVER) {
            root.registerNotification(ATTRIBUTE_VALUE_WRITTEN, true);
        }
    }
}

