/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.provider;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.provider.ServiceProviderRegistration;
import org.wildfly.clustering.provider.ServiceProviderRegistrationFactory;
import org.wildfly.clustering.server.provider.ServiceProviderRegistrationFactoryConfiguration;
import org.wildfly.clustering.server.provider.ServiceRegistry;
import org.wildfly.clustering.server.provider.ServiceRegistryCommand;

@Listener
public class ServiceProviderRegistrationFactoryService
implements ServiceProviderRegistrationFactory,
ServiceRegistry,
Group.Listener,
Service<ServiceProviderRegistrationFactory> {
    private final ServiceProviderRegistrationFactoryConfiguration config;
    final ConcurrentMap<Object, ServiceProviderRegistration.Listener> listeners = new ConcurrentHashMap<Object, ServiceProviderRegistration.Listener>();
    volatile Group group = null;
    volatile Cache<Object, Set<Node>> cache = null;
    volatile CacheInvoker invoker = null;
    private volatile CommandDispatcher<ServiceRegistry> dispatcher = null;

    public ServiceProviderRegistrationFactoryService(ServiceProviderRegistrationFactoryConfiguration config) {
        this.config = config;
    }

    public Group getGroup() {
        return this.group;
    }

    public ServiceProviderRegistration createRegistration(final Object service, ServiceProviderRegistration.Listener listener) {
        if (this.listeners.putIfAbsent(service, listener) != null) {
            throw new IllegalArgumentException(service.toString());
        }
        final Node node = this.group.getLocalNode();
        Operation<Set<Node>> operation = new Operation<Set<Node>>(){

            public Set<Node> invoke(Cache<Object, Set<Node>> cache) {
                HashSet<Node> nodes = new HashSet<Node>(Collections.singleton(node));
                HashSet<Node> existing = (HashSet<Node>)cache.putIfAbsent(service, nodes);
                if (existing != null && existing.add(node)) {
                    cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).replace(service, existing);
                }
                return existing != null ? existing : nodes;
            }
        };
        this.invoker.invoke(this.cache, (CacheInvoker.Operation)operation, new Flag[0]);
        return new ServiceProviderRegistration(){

            public Object getService() {
                return service;
            }

            public Set<Node> getProviders() {
                return ServiceProviderRegistrationFactoryService.this.getProviders(service);
            }

            public void close() {
                if (ServiceProviderRegistrationFactoryService.this.listeners.remove(service) != null) {
                    final Node node = ServiceProviderRegistrationFactoryService.this.group.getLocalNode();
                    Operation<Void> operation = new Operation<Void>(){

                        public Void invoke(Cache<Object, Set<Node>> cache) {
                            Set nodes = (Set)cache.get(service);
                            if (nodes != null && nodes.remove(node)) {
                                if (nodes.isEmpty()) {
                                    cache.remove(service);
                                } else {
                                    cache.replace(service, (Object)nodes);
                                }
                            }
                            return null;
                        }
                    };
                    ServiceProviderRegistrationFactoryService.this.invoker.invoke(ServiceProviderRegistrationFactoryService.this.cache, (CacheInvoker.Operation)operation, new Flag[]{Flag.IGNORE_RETURN_VALUES});
                }
            }
        };
    }

    public Set<Node> getProviders(final Object service) {
        Operation<Set<Node>> operation = new Operation<Set<Node>>(){

            public Set<Node> invoke(Cache<Object, Set<Node>> cache) {
                return (Set)cache.get(service);
            }
        };
        Set nodes = (Set)this.invoker.invoke(this.cache, (CacheInvoker.Operation)operation, new Flag[0]);
        return nodes != null ? Collections.unmodifiableSet(nodes) : Collections.emptySet();
    }

    @Override
    public Set<Object> getServices() {
        return this.listeners.keySet();
    }

    public ServiceProviderRegistrationFactory getValue() {
        return this;
    }

    public void start(StartContext context) {
        this.invoker = this.config.getCacheInvoker();
        this.group = this.config.getGroup();
        this.cache = this.config.getCache();
        this.dispatcher = this.config.getCommandDispatcherFactory().createCommandDispatcher(this.config.getId(), (Object)this);
        this.cache.addListener((Object)this);
        this.group.addListener((Group.Listener)this);
    }

    public void stop(StopContext context) {
        this.group.removeListener((Group.Listener)this);
        this.cache.removeListener((Object)this);
        this.dispatcher.close();
    }

    public void membershipChanged(List<Node> previousMembers, List<Node> members, final boolean merged) {
        if (this.group.isCoordinator()) {
            final HashSet<Node> deadNodes = new HashSet<Node>(previousMembers);
            deadNodes.removeAll(members);
            final HashSet<Node> newNodes = new HashSet<Node>(members);
            newNodes.removeAll(previousMembers);
            Operation<Void> operation = new Operation<Void>(){

                public Void invoke(Cache<Object, Set<Node>> cache) {
                    if (!deadNodes.isEmpty()) {
                        for (Object service : cache.keySet()) {
                            Set nodes = (Set)cache.get(service);
                            if (nodes == null || !nodes.removeAll(deadNodes)) continue;
                            cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).replace(service, (Object)nodes);
                        }
                    }
                    if (merged) {
                        for (Node node : newNodes) {
                            List<Object> services = ServiceProviderRegistrationFactoryService.this.getServices(node);
                            for (Object service : services) {
                                HashSet<Node> nodes;
                                Set existing = (Set)cache.putIfAbsent(service, nodes = new HashSet<Node>(Collections.singleton(node)));
                                if (existing == null || !existing.add(node)) continue;
                                cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).replace(service, (Object)existing);
                            }
                        }
                    }
                    return null;
                }
            };
            this.invoker.invoke(this.cache, (CacheInvoker.Operation)operation, new Flag[0]);
        }
    }

    @CacheEntryModified
    public void modified(CacheEntryModifiedEvent<ServiceName, Set<Node>> event) {
        if (event.isPre()) {
            return;
        }
        ServiceProviderRegistration.Listener listener = (ServiceProviderRegistration.Listener)this.listeners.get(event.getKey());
        if (listener != null) {
            listener.providersChanged((Set)event.getValue());
        }
    }

    List<Object> getServices(Node node) {
        try {
            return (List)this.dispatcher.executeOnNode((Command)new ServiceRegistryCommand(), node).get();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    static interface Operation<R>
    extends CacheInvoker.Operation<Object, Set<Node>, R> {
    }
}

