/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.stomp;

import java.util.HashMap;
import java.util.Map;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.protocol.stomp.HornetQStompException;
import org.hornetq.core.protocol.stomp.HornetQStompProtocolMessageBundle;
import org.hornetq.core.protocol.stomp.StompFrame;

public class StompDecoder {
    public static final boolean TRIM_LEADING_HEADER_VALUE_WHITESPACE = true;
    public static final String COMMAND_ABORT = "ABORT";
    public static final int COMMAND_ABORT_LENGTH = "ABORT".length();
    public static final String COMMAND_ACK = "ACK";
    public static final int COMMAND_ACK_LENGTH = "ACK".length();
    public static final String COMMAND_NACK = "NACK";
    public static final int COMMAND_NACK_LENGTH = "NACK".length();
    public static final String COMMAND_BEGIN = "BEGIN";
    public static final int COMMAND_BEGIN_LENGTH = "BEGIN".length();
    public static final String COMMAND_COMMIT = "COMMIT";
    public static final int COMMAND_COMMIT_LENGTH = "COMMIT".length();
    public static final String COMMAND_CONNECT = "CONNECT";
    public static final int COMMAND_CONNECT_LENGTH = "CONNECT".length();
    public static final String COMMAND_DISCONNECT = "DISCONNECT";
    public static final int COMMAND_DISCONNECT_LENGTH = "DISCONNECT".length();
    public static final String COMMAND_SEND = "SEND";
    public static final int COMMAND_SEND_LENGTH = "SEND".length();
    public static final String COMMAND_STOMP = "STOMP";
    public static final int COMMAND_STOMP_LENGTH = "STOMP".length();
    public static final String COMMAND_SUBSCRIBE = "SUBSCRIBE";
    public static final int COMMAND_SUBSCRIBE_LENGTH = "SUBSCRIBE".length();
    public static final String COMMAND_UNSUBSCRIBE = "UNSUBSCRIBE";
    public static final int COMMAND_UNSUBSCRIBE_LENGTH = "UNSUBSCRIBE".length();
    public static final String COMMAND_CONNECTED = "CONNECTED";
    public static final int COMMAND_CONNECTED_LENGTH = "CONNECTED".length();
    public static final String COMMAND_MESSAGE = "MESSAGE";
    public static final int COMMAND_MESSAGE_LENGTH = "MESSAGE".length();
    public static final String COMMAND_ERROR = "ERROR";
    public static final int COMMAND_ERROR_LENGTH = "ERROR".length();
    public static final String COMMAND_RECEIPT = "RECEIPT";
    public static final int COMMAND_RECEIPT_LENGTH = "RECEIPT".length();
    public static final byte A = 65;
    public static final byte B = 66;
    public static final byte C = 67;
    public static final byte c = 99;
    public static final byte D = 68;
    public static final byte E = 69;
    public static final byte T = 84;
    public static final byte M = 77;
    public static final byte S = 83;
    public static final byte R = 82;
    public static final byte U = 85;
    public static final byte N = 78;
    public static final byte LN = 110;
    public static final byte RT = 114;
    public static final byte HEADER_SEPARATOR = 58;
    public static final byte NEW_LINE = 10;
    public static final byte CR = 13;
    public static final byte SPACE = 32;
    public static final byte TAB = 9;
    public static final String CONTENT_TYPE_HEADER_NAME = "content-type";
    public static final String CONTENT_LENGTH_HEADER_NAME = "content-length";
    public byte[] workingBuffer = new byte[1024];
    public int pos;
    public int data;
    public String command;
    public Map<String, String> headers;
    private int headerBytesCopyStart;
    public boolean readingHeaders;
    public boolean headerValueWhitespace;
    public boolean inHeaderName;
    public String headerName;
    public boolean whiteSpaceOnly;
    public int contentLength;
    public String contentType;
    public int bodyStart;
    protected int eolLen = 1;

    public boolean hasBytes() {
        return this.data > this.pos;
    }

    public synchronized StompFrame decode(HornetQBuffer buffer) throws HornetQStompException {
        int readable = buffer.readableBytes();
        if (this.data + readable >= this.workingBuffer.length) {
            this.resizeWorking(this.data + readable);
        }
        buffer.readBytes(this.workingBuffer, this.data, readable);
        this.data += readable;
        if (this.command == null && !this.parseCommand()) {
            return null;
        }
        if (this.readingHeaders && !this.parseHeaders()) {
            return null;
        }
        StompFrame ret = this.parseBody();
        return ret;
    }

    protected StompFrame parseBody() throws HornetQStompException {
        byte[] content;
        block7: {
            block6: {
                content = null;
                if (this.contentLength == -1) break block6;
                if (this.pos + this.contentLength + 1 > this.data) break block7;
                content = new byte[this.contentLength];
                System.arraycopy(this.workingBuffer, this.pos, content, 0, this.contentLength);
                this.pos += this.contentLength + 1;
                break block7;
            }
            if (this.bodyStart == -1) {
                this.bodyStart = this.pos;
            }
            while (this.pos < this.data) {
                if (this.workingBuffer[this.pos++] != 0) continue;
                content = new byte[this.pos - this.bodyStart - 1];
                System.arraycopy(this.workingBuffer, this.bodyStart, content, 0, content.length);
                break;
            }
        }
        if (content != null) {
            if (this.data > this.pos) {
                if (this.workingBuffer[this.pos] == 10) {
                    ++this.pos;
                }
                if (this.data > this.pos) {
                    System.arraycopy(this.workingBuffer, this.pos, this.workingBuffer, 0, this.data - this.pos);
                }
            }
            this.data -= this.pos;
            StompFrame ret = new StompFrame(this.command, this.headers, content);
            this.init();
            return ret;
        }
        return null;
    }

    protected boolean parseHeaders() throws HornetQStompException {
        block10: {
            if (this.headerBytesCopyStart == -1) {
                this.headerBytesCopyStart = this.pos;
            }
            block5: do {
                byte b = this.workingBuffer[this.pos++];
                switch (b) {
                    case 58: {
                        byte[] data;
                        if (this.inHeaderName) {
                            data = new byte[this.pos - this.headerBytesCopyStart - 1];
                            System.arraycopy(this.workingBuffer, this.headerBytesCopyStart, data, 0, data.length);
                            this.headerName = new String(data);
                            this.inHeaderName = false;
                            this.headerBytesCopyStart = this.pos;
                            this.headerValueWhitespace = true;
                        }
                        this.whiteSpaceOnly = false;
                        break;
                    }
                    case 10: {
                        if (this.whiteSpaceOnly) {
                            this.readingHeaders = false;
                            break block10;
                        }
                        byte[] data = new byte[this.pos - this.headerBytesCopyStart - 1];
                        System.arraycopy(this.workingBuffer, this.headerBytesCopyStart, data, 0, data.length);
                        String headerValue = new String(data);
                        this.headers.put(this.headerName, headerValue);
                        if (this.headerName.equals(CONTENT_LENGTH_HEADER_NAME)) {
                            this.contentLength = Integer.parseInt(headerValue.toString());
                        }
                        this.whiteSpaceOnly = true;
                        this.headerBytesCopyStart = this.pos;
                        this.inHeaderName = true;
                        this.headerValueWhitespace = false;
                        break;
                    }
                    case 9: 
                    case 32: {
                        if (!this.headerValueWhitespace) continue block5;
                        ++this.headerBytesCopyStart;
                        break;
                    }
                    default: {
                        this.whiteSpaceOnly = false;
                        this.headerValueWhitespace = false;
                    }
                }
            } while (this.pos != this.data);
            return false;
        }
        return true;
    }

    protected boolean parseCommand() throws HornetQStompException {
        int offset;
        boolean nextChar = false;
        for (offset = 0; offset < this.data; ++offset) {
            if (this.workingBuffer[offset] == 10) {
                nextChar = false;
                continue;
            }
            if (this.workingBuffer[offset] != 13) break;
            if (nextChar) {
                throw HornetQStompProtocolMessageBundle.BUNDLE.invalidTwoCRs();
            }
            nextChar = true;
        }
        if (nextChar) {
            throw HornetQStompProtocolMessageBundle.BUNDLE.badCRs();
        }
        if (this.data < 4 + offset) {
            return false;
        }
        byte b = this.workingBuffer[offset];
        switch (b) {
            case 65: {
                if (this.workingBuffer[offset + 1] == 66) {
                    if (!this.tryIncrement(offset + COMMAND_ABORT_LENGTH + 1)) {
                        return false;
                    }
                    this.command = COMMAND_ABORT;
                    break;
                }
                if (!this.tryIncrement(offset + COMMAND_ACK_LENGTH + 1)) {
                    return false;
                }
                this.command = COMMAND_ACK;
                break;
            }
            case 66: {
                if (!this.tryIncrement(offset + COMMAND_BEGIN_LENGTH + 1)) {
                    return false;
                }
                this.command = COMMAND_BEGIN;
                break;
            }
            case 67: {
                if (this.workingBuffer[offset + 2] == 77) {
                    if (!this.tryIncrement(offset + COMMAND_COMMIT_LENGTH + 1)) {
                        return false;
                    }
                    this.command = COMMAND_COMMIT;
                    break;
                }
                if (this.workingBuffer[offset + 7] == 69) {
                    if (!this.tryIncrement(offset + COMMAND_CONNECTED_LENGTH + 1)) {
                        return false;
                    }
                    this.command = COMMAND_CONNECTED;
                    break;
                }
                if (!this.tryIncrement(offset + COMMAND_CONNECT_LENGTH + 1)) {
                    return false;
                }
                this.command = COMMAND_CONNECT;
                break;
            }
            case 68: {
                if (!this.tryIncrement(offset + COMMAND_DISCONNECT_LENGTH + 1)) {
                    return false;
                }
                this.command = COMMAND_DISCONNECT;
                break;
            }
            case 82: {
                if (!this.tryIncrement(offset + COMMAND_RECEIPT_LENGTH + 1)) {
                    return false;
                }
                this.command = COMMAND_RECEIPT;
                break;
            }
            case 69: {
                if (!this.tryIncrement(offset + COMMAND_ERROR_LENGTH + 1)) {
                    return false;
                }
                this.command = COMMAND_ERROR;
                break;
            }
            case 77: {
                if (!this.tryIncrement(offset + COMMAND_MESSAGE_LENGTH + 1)) {
                    return false;
                }
                this.command = COMMAND_MESSAGE;
                break;
            }
            case 83: {
                if (this.workingBuffer[offset + 1] == 69) {
                    if (!this.tryIncrement(offset + COMMAND_SEND_LENGTH + 1)) {
                        return false;
                    }
                    this.command = COMMAND_SEND;
                    break;
                }
                if (this.workingBuffer[offset + 1] == 84) {
                    if (!this.tryIncrement(offset + COMMAND_STOMP_LENGTH + 1)) {
                        return false;
                    }
                    this.command = COMMAND_STOMP;
                    break;
                }
                if (!this.tryIncrement(offset + COMMAND_SUBSCRIBE_LENGTH + 1)) {
                    return false;
                }
                this.command = COMMAND_SUBSCRIBE;
                break;
            }
            case 85: {
                if (!this.tryIncrement(offset + COMMAND_UNSUBSCRIBE_LENGTH + 1)) {
                    return false;
                }
                this.command = COMMAND_UNSUBSCRIBE;
                break;
            }
            default: {
                this.throwInvalid();
            }
        }
        if (this.workingBuffer[this.pos - 1] != 10) {
            HornetQStompException error = HornetQStompProtocolMessageBundle.BUNDLE.notValidNewLine(this.workingBuffer[this.pos - 1]);
            error.setCode(1);
            error.setBody(HornetQStompProtocolMessageBundle.BUNDLE.unexpectedNewLine(this.workingBuffer[this.pos - 1]));
            throw error;
        }
        return true;
    }

    public void throwInvalid() throws HornetQStompException {
        HornetQStompException error = HornetQStompProtocolMessageBundle.BUNDLE.invalidCommand(this.dumpByteArray(this.workingBuffer));
        error.setCode(2);
        error.setBody(HornetQStompProtocolMessageBundle.BUNDLE.invalidFrame(this.dumpByteArray(this.workingBuffer)));
        throw error;
    }

    public void init() {
        this.pos = 0;
        this.command = null;
        this.headers = new HashMap<String, String>();
        this.headerBytesCopyStart = -1;
        this.readingHeaders = true;
        this.inHeaderName = true;
        this.headerValueWhitespace = false;
        this.headerName = null;
        this.whiteSpaceOnly = true;
        this.contentLength = -1;
        this.contentType = null;
        this.bodyStart = -1;
    }

    public void resizeWorking(int newSize) {
        byte[] oldBuffer = this.workingBuffer;
        this.workingBuffer = new byte[newSize];
        System.arraycopy(oldBuffer, 0, this.workingBuffer, 0, oldBuffer.length);
    }

    public boolean tryIncrement(int length) {
        if (this.pos + length >= this.data) {
            return false;
        }
        this.pos += length;
        return true;
    }

    private String dumpByteArray(byte[] bytes) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.data; ++i) {
            char b = (char)bytes[i];
            if (b < '!' || b > '\u0088') {
                str.append(bytes[i]);
            } else {
                str.append(b);
            }
            if (i == bytes.length - 1) continue;
            str.append(",");
        }
        return str.toString();
    }

    public void init(StompDecoder decoder) {
    }
}

