/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.blocks.Connection;
import org.jgroups.blocks.ConnectionMap;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.Util;

public abstract class AbstractConnectionMap<V extends Connection>
implements ConnectionMap<V> {
    protected final List<ConnectionMapListener<V>> conn_listeners = new ArrayList<ConnectionMapListener<V>>();
    protected final Map<Address, V> conns = new HashMap<Address, V>();
    protected final Lock lock = new ReentrantLock();
    protected final Lock sock_creation_lock = new ReentrantLock(true);
    protected final ThreadFactory factory;
    protected final long reaperInterval;
    protected final Reaper reaper;

    public AbstractConnectionMap(ThreadFactory factory) {
        this(factory, 0L);
    }

    public AbstractConnectionMap(ThreadFactory factory, long reaperInterval) {
        this.factory = factory;
        this.reaperInterval = reaperInterval;
        this.reaper = reaperInterval > 0L ? new Reaper() : null;
    }

    public Lock getLock() {
        return this.lock;
    }

    public boolean hasConnection(Address address) {
        return this.conns.containsKey(address);
    }

    public void addConnection(Address address, V conn) {
        Connection previous = (Connection)this.conns.put(address, conn);
        Util.close(previous);
        this.notifyConnectionOpened(address, conn);
    }

    public void addConnectionMapListener(ConnectionMapListener<V> cml) {
        if (cml != null && !this.conn_listeners.contains(cml)) {
            this.conn_listeners.add(cml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumConnections() {
        this.lock.lock();
        try {
            int n = this.conns.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumOpenConnections() {
        int retval = 0;
        this.lock.lock();
        try {
            for (Connection conn : this.conns.values()) {
                if (!conn.isOpen()) continue;
                ++retval;
            }
            int n = retval;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printConnections() {
        StringBuilder sb = new StringBuilder();
        this.lock.lock();
        try {
            for (Map.Entry<Address, V> entry : this.conns.entrySet()) {
                sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
            }
        }
        finally {
            this.lock.unlock();
        }
        return sb.toString();
    }

    public ThreadFactory getThreadFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionIfPresent(Address address, V conn) {
        if (address == null || conn == null) {
            return;
        }
        this.lock.lock();
        try {
            Connection existing = (Connection)this.conns.get(address);
            if (conn == existing) {
                Connection tmp = (Connection)this.conns.remove(address);
                Util.close(tmp);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeConnectionMapListener(ConnectionMapListener<V> cml) {
        if (cml != null) {
            this.conn_listeners.remove(cml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retainAll(Collection<Address> current_mbrs) {
        if (current_mbrs == null) {
            return;
        }
        HashMap<Address, V> copy = null;
        this.lock.lock();
        try {
            copy = new HashMap<Address, V>(this.conns);
            this.conns.keySet().retainAll(current_mbrs);
        }
        finally {
            this.lock.unlock();
        }
        copy.keySet().removeAll(current_mbrs);
        for (Map.Entry e : copy.entrySet()) {
            Util.close((Connection)e.getValue());
        }
        copy.clear();
    }

    public void start() throws Exception {
        if (this.reaper != null) {
            this.reaper.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.reaper != null) {
            this.reaper.stop();
        }
        this.lock.lock();
        try {
            for (Map.Entry<Address, V> e : this.conns.entrySet()) {
                Util.close((Connection)e.getValue());
            }
            this.clear();
        }
        finally {
            this.lock.unlock();
        }
        this.conn_listeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        this.lock.lock();
        try {
            this.conns.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void notifyConnectionClosed(Address address) {
        for (ConnectionMapListener<V> l : this.conn_listeners) {
            l.connectionClosed(address);
        }
    }

    protected void notifyConnectionOpened(Address address, V conn) {
        for (ConnectionMapListener<V> l : this.conn_listeners) {
            l.connectionOpened(address, conn);
        }
    }

    public static interface ConnectionMapListener<V> {
        public void connectionClosed(Address var1);

        public void connectionOpened(Address var1, V var2);
    }

    class Reaper
    implements Runnable {
        private Thread thread;

        Reaper() {
        }

        public synchronized void start() {
            if (this.thread == null || !this.thread.isAlive()) {
                this.thread = AbstractConnectionMap.this.factory.newThread(new Reaper(), "Reaper");
                this.thread.start();
            }
        }

        public synchronized void stop() {
            if (this.thread != null && this.thread.isAlive()) {
                this.thread.interrupt();
                try {
                    this.thread.join(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.thread = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                AbstractConnectionMap.this.lock.lock();
                try {
                    Iterator it = AbstractConnectionMap.this.conns.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        Connection c = (Connection)entry.getValue();
                        if (!c.isExpired(System.currentTimeMillis())) continue;
                        Util.close(c);
                        it.remove();
                    }
                }
                finally {
                    AbstractConnectionMap.this.lock.unlock();
                }
                Util.sleep(AbstractConnectionMap.this.reaperInterval);
            }
        }
    }
}

