/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.jgroups;

import org.hibernate.search.backend.impl.jgroups.MessageSender;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

final class DispatcherMessageSender
implements MessageSender {
    private static final Log log = LoggerFactory.make();
    private final MessageDispatcher dispatcher;
    private final Channel channel;

    DispatcherMessageSender(MessageDispatcher dispatcher) {
        this.dispatcher = dispatcher;
        this.channel = dispatcher.getChannel();
    }

    @Override
    public Address getAddress() {
        return this.channel.getAddress();
    }

    @Override
    public View getView() {
        return this.channel.getView();
    }

    @Override
    public void stop() {
        this.dispatcher.stop();
    }

    @Override
    public void send(Message message, boolean synchronous, long timeout) throws Exception {
        RequestOptions options = synchronous ? RequestOptions.SYNC() : RequestOptions.ASYNC();
        options.setExclusionList(new Address[]{this.dispatcher.getChannel().getAddress()});
        options.setTimeout(timeout);
        RspList rspList = this.dispatcher.castMessage(null, message, options);
        if (synchronous) {
            for (Rsp rsp : rspList.values()) {
                if (!rsp.wasReceived()) {
                    if (rsp.wasSuspected()) {
                        throw log.jgroupsSuspectingPeer(rsp.getSender());
                    }
                    throw log.jgroupsRpcTimeout(rsp.getSender());
                }
                if (!rsp.hasException()) continue;
                throw log.jgroupsRemoteException(rsp.getSender(), rsp.getException(), rsp.getException());
            }
        }
    }
}

