/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.analysis.Analyzer;
import org.hibernate.search.SearchException;
import org.hibernate.search.Version;
import org.hibernate.search.backend.impl.batch.BatchBackend;
import org.hibernate.search.backend.impl.batch.DefaultBatchBackend;
import org.hibernate.search.backend.spi.Worker;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.IndexManagerFactory;
import org.hibernate.search.engine.ServiceManager;
import org.hibernate.search.engine.impl.FilterDef;
import org.hibernate.search.engine.spi.AbstractDocumentBuilder;
import org.hibernate.search.engine.spi.DocumentBuilderContainedEntity;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinder;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.engine.spi.TimingSource;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.filter.FilterCachingStrategy;
import org.hibernate.search.impl.EntityIndexBindingWrapper;
import org.hibernate.search.indexes.IndexReaderAccessor;
import org.hibernate.search.indexes.impl.DefaultIndexReaderAccessor;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.jmx.StatisticsInfo;
import org.hibernate.search.jmx.impl.JMXRegistrar;
import org.hibernate.search.metadata.IndexedTypeDescriptor;
import org.hibernate.search.metadata.impl.IndexedTypeDescriptorForUnindexedType;
import org.hibernate.search.metadata.impl.IndexedTypeDescriptorImpl;
import org.hibernate.search.query.dsl.QueryContextBuilder;
import org.hibernate.search.query.dsl.impl.ConnectedQueryContextBuilder;
import org.hibernate.search.query.engine.impl.HSQueryImpl;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.engine.spi.TimeoutExceptionFactory;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.spi.ServiceProvider;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.spi.internals.PolymorphicIndexHierarchy;
import org.hibernate.search.spi.internals.SearchFactoryImplementorWithShareableState;
import org.hibernate.search.spi.internals.SearchFactoryState;
import org.hibernate.search.stat.Statistics;
import org.hibernate.search.stat.impl.StatisticsImpl;
import org.hibernate.search.stat.spi.StatisticsImplementor;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ImmutableSearchFactory
implements SearchFactoryImplementorWithShareableState,
WorkerBuildContext {
    private static final Log log;
    private final Map<Class<?>, EntityIndexBinding> indexBindingForEntities;
    private final Map<Class<?>, DocumentBuilderContainedEntity<?>> documentBuildersContainedEntities;
    private final ConcurrentHashMap<Class<?>, IndexedTypeDescriptor> indexedTypeDescriptors;
    private final Worker worker;
    private final Map<String, FilterDef> filterDefinitions;
    private final FilterCachingStrategy filterCachingStrategy;
    private final Map<String, Analyzer> analyzers;
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final int cacheBitResultsSize;
    private final Properties configurationProperties;
    private final PolymorphicIndexHierarchy indexHierarchy;
    private final StatisticsImpl statistics;
    private final boolean transactionManagerExpected;
    private final IndexManagerHolder allIndexesManager;
    private final ErrorHandler errorHandler;
    private final String indexingStrategy;
    private final ServiceManager serviceManager;
    private final boolean enableDirtyChecks;
    private final DefaultIndexReaderAccessor indexReaderAccessor;
    private final InstanceInitializer instanceInitializer;
    private final TimeoutExceptionFactory timeoutExceptionFactory;
    private final TimingSource timingSource;
    private final SearchMapping mapping;
    private final boolean indexMetadataIsComplete;
    private final boolean isIdProvidedImplicit;
    private final String statisticsMBeanName;
    private final IndexManagerFactory indexManagerFactory;

    public ImmutableSearchFactory(SearchFactoryState state) {
        this.analyzers = state.getAnalyzers();
        this.cacheBitResultsSize = state.getCacheBitResultsSize();
        this.configurationProperties = state.getConfigurationProperties();
        this.indexBindingForEntities = state.getIndexBindings();
        this.documentBuildersContainedEntities = state.getDocumentBuildersContainedEntities();
        this.filterCachingStrategy = state.getFilterCachingStrategy();
        this.filterDefinitions = state.getFilterDefinitions();
        this.indexHierarchy = state.getIndexHierarchy();
        this.indexingStrategy = state.getIndexingStrategy();
        this.worker = state.getWorker();
        this.serviceManager = state.getServiceManager();
        this.transactionManagerExpected = state.isTransactionManagerExpected();
        this.allIndexesManager = state.getAllIndexesManager();
        this.errorHandler = state.getErrorHandler();
        this.instanceInitializer = state.getInstanceInitializer();
        this.timeoutExceptionFactory = state.getDefaultTimeoutExceptionFactory();
        this.timingSource = state.getTimingSource();
        this.mapping = state.getProgrammaticMapping();
        this.statistics = new StatisticsImpl(this);
        this.indexMetadataIsComplete = state.isIndexMetadataComplete();
        this.isIdProvidedImplicit = state.isIdProvidedImplicit();
        this.indexManagerFactory = state.getIndexManagerFactory();
        boolean statsEnabled = ConfigurationParseHelper.getBooleanValue(this.configurationProperties, "hibernate.search.generate_statistics", false);
        this.statistics.setStatisticsEnabled(statsEnabled);
        this.enableDirtyChecks = ConfigurationParseHelper.getBooleanValue(this.configurationProperties, "hibernate.search.enable_dirty_check", true);
        this.statisticsMBeanName = this.isJMXEnabled() ? this.registerMBeans() : null;
        this.indexReaderAccessor = new DefaultIndexReaderAccessor(this);
        this.indexedTypeDescriptors = new ConcurrentHashMap();
    }

    @Override
    public Map<String, FilterDef> getFilterDefinitions() {
        return this.filterDefinitions;
    }

    @Override
    public String getIndexingStrategy() {
        return this.indexingStrategy;
    }

    @Override
    public void close() {
        if (this.stopped.compareAndSet(false, true)) {
            try {
                this.worker.close();
            }
            catch (Exception e) {
                log.workerException(e);
            }
            this.allIndexesManager.stop();
            this.timingSource.stop();
            this.serviceManager.stopServices();
            for (Analyzer analyzer : this.analyzers.values()) {
                analyzer.close();
            }
            for (AbstractDocumentBuilder abstractDocumentBuilder : this.documentBuildersContainedEntities.values()) {
                abstractDocumentBuilder.close();
            }
            for (EntityIndexBinding entityIndexBinding : this.indexBindingForEntities.values()) {
                entityIndexBinding.getDocumentBuilder().close();
            }
            if (this.statisticsMBeanName != null) {
                JMXRegistrar.unRegisterMBean(this.statisticsMBeanName);
            }
        }
    }

    @Override
    public HSQuery createHSQuery() {
        return new HSQueryImpl(this);
    }

    @Override
    public Map<Class<?>, DocumentBuilderContainedEntity<?>> getDocumentBuildersContainedEntities() {
        return this.documentBuildersContainedEntities;
    }

    @Override
    public Map<Class<?>, EntityIndexBinding> getIndexBindings() {
        return this.indexBindingForEntities;
    }

    @Override
    public Map<Class<?>, EntityIndexBinder> getIndexBindingForEntity() {
        HashMap tmpMap = new HashMap();
        for (Map.Entry<Class<?>, EntityIndexBinding> entry : this.indexBindingForEntities.entrySet()) {
            tmpMap.put(entry.getKey(), new EntityIndexBindingWrapper(entry.getValue()));
        }
        return tmpMap;
    }

    @Override
    public EntityIndexBinder getIndexBindingForEntity(Class<?> entityType) {
        EntityIndexBinding entityIndexBinding = this.indexBindingForEntities.get(entityType);
        if (entityIndexBinding == null) {
            return null;
        }
        return new EntityIndexBindingWrapper(entityIndexBinding);
    }

    @Override
    public EntityIndexBinding getIndexBinding(Class<?> entityType) {
        return this.indexBindingForEntities.get(entityType);
    }

    @Override
    public <T> DocumentBuilderContainedEntity<T> getDocumentBuilderContainedEntity(Class<T> entityType) {
        return this.documentBuildersContainedEntities.get(entityType);
    }

    @Override
    public void addClasses(Class<?> ... classes) {
        throw new AssertionFailure("Cannot add classes to an " + ImmutableSearchFactory.class.getName());
    }

    @Override
    public Worker getWorker() {
        return this.worker;
    }

    @Override
    public void optimize() {
        for (IndexManager im : this.allIndexesManager.getIndexManagers()) {
            im.optimize();
        }
    }

    @Override
    public void optimize(Class entityType) {
        EntityIndexBinding entityIndexBinding = this.getSafeIndexBindingForEntity(entityType);
        for (IndexManager im : entityIndexBinding.getIndexManagers()) {
            im.optimize();
        }
    }

    @Override
    public Analyzer getAnalyzer(String name) {
        Analyzer analyzer = this.analyzers.get(name);
        if (analyzer == null) {
            throw new SearchException("Unknown Analyzer definition: " + name);
        }
        return analyzer;
    }

    @Override
    public Analyzer getAnalyzer(Class<?> clazz) {
        EntityIndexBinding entityIndexBinding = this.getSafeIndexBindingForEntity(clazz);
        DocumentBuilderIndexedEntity<?> builder = entityIndexBinding.getDocumentBuilder();
        return builder.getAnalyzer();
    }

    @Override
    public QueryContextBuilder buildQueryBuilder() {
        return new ConnectedQueryContextBuilder(this);
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    public StatisticsImplementor getStatisticsImplementor() {
        return this.statistics;
    }

    @Override
    public FilterCachingStrategy getFilterCachingStrategy() {
        return this.filterCachingStrategy;
    }

    @Override
    public Map<String, Analyzer> getAnalyzers() {
        return this.analyzers;
    }

    @Override
    public int getCacheBitResultsSize() {
        return this.cacheBitResultsSize;
    }

    @Override
    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    @Override
    public FilterDef getFilterDefinition(String name) {
        return this.filterDefinitions.get(name);
    }

    @Override
    public <T> T requestService(Class<? extends ServiceProvider<T>> provider) {
        return this.serviceManager.requestService(provider, this);
    }

    @Override
    public void releaseService(Class<? extends ServiceProvider<?>> provider) {
        this.serviceManager.releaseService(provider);
    }

    @Override
    public int getFilterCacheBitResultsSize() {
        return this.cacheBitResultsSize;
    }

    @Override
    public Set<Class<?>> getIndexedTypesPolymorphic(Class<?>[] classes) {
        return this.indexHierarchy.getIndexedClasses(classes);
    }

    @Override
    public BatchBackend makeBatchBackend(MassIndexerProgressMonitor progressMonitor) {
        return new DefaultBatchBackend(this, progressMonitor);
    }

    @Override
    public PolymorphicIndexHierarchy getIndexHierarchy() {
        return this.indexHierarchy;
    }

    @Override
    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    @Override
    public SearchFactoryImplementor getUninitializedSearchFactory() {
        return this;
    }

    @Override
    public boolean isJMXEnabled() {
        String enableJMX = this.getConfigurationProperties().getProperty("hibernate.search.jmx_enabled");
        return "true".equalsIgnoreCase(enableJMX);
    }

    private String registerMBeans() {
        String mbeanNameSuffix = this.getConfigurationProperties().getProperty("hibernate.search.jmx_bean_suffix");
        String objectName = JMXRegistrar.buildMBeanName("org.hibernate.search.jmx:type=StatisticsInfoMBean", mbeanNameSuffix);
        if (JMXRegistrar.isNameRegistered(objectName)) {
            JMXRegistrar.unRegisterMBean(objectName);
        }
        StatisticsInfo statisticsInfo = new StatisticsInfo(this.statistics);
        JMXRegistrar.registerMBean(statisticsInfo, objectName);
        return objectName;
    }

    @Override
    public boolean isDirtyChecksEnabled() {
        return this.enableDirtyChecks;
    }

    @Override
    public boolean isStopped() {
        return this.stopped.get();
    }

    @Override
    public boolean isTransactionManagerExpected() {
        return this.transactionManagerExpected;
    }

    @Override
    public IndexManagerHolder getAllIndexesManager() {
        return this.getIndexManagerHolder();
    }

    @Override
    public IndexManagerHolder getIndexManagerHolder() {
        return this.allIndexesManager;
    }

    public EntityIndexBinding getSafeIndexBindingForEntity(Class<?> entityType) {
        if (entityType == null) {
            throw log.nullIsInvalidIndexedType();
        }
        EntityIndexBinding entityIndexBinding = this.getIndexBinding(entityType);
        if (entityIndexBinding == null) {
            throw log.notAnIndexedType(entityType.getName());
        }
        return entityIndexBinding;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public IndexReaderAccessor getIndexReaderAccessor() {
        return this.indexReaderAccessor;
    }

    @Override
    public IndexedTypeDescriptor getIndexedTypeDescriptor(Class<?> entityType) {
        IndexedTypeDescriptor typeDescriptor;
        if (this.indexedTypeDescriptors.containsKey(entityType)) {
            typeDescriptor = this.indexedTypeDescriptors.get(entityType);
        } else {
            EntityIndexBinding indexBinder = this.indexBindingForEntities.get(entityType);
            IndexedTypeDescriptor indexedTypeDescriptor = indexBinder == null ? new IndexedTypeDescriptorForUnindexedType(entityType) : new IndexedTypeDescriptorImpl(indexBinder.getDocumentBuilder().getMetadata(), indexBinder.getIndexManagers());
            this.indexedTypeDescriptors.put(entityType, indexedTypeDescriptor);
            typeDescriptor = indexedTypeDescriptor;
        }
        return typeDescriptor;
    }

    @Override
    public Set<Class<?>> getIndexedTypes() {
        return this.indexBindingForEntities.keySet();
    }

    @Override
    public InstanceInitializer getInstanceInitializer() {
        return this.instanceInitializer;
    }

    @Override
    public TimeoutExceptionFactory getDefaultTimeoutExceptionFactory() {
        return this.timeoutExceptionFactory;
    }

    @Override
    public TimingSource getTimingSource() {
        return this.timingSource;
    }

    @Override
    public SearchMapping getProgrammaticMapping() {
        return this.mapping;
    }

    @Override
    public boolean isIndexMetadataComplete() {
        return this.indexMetadataIsComplete;
    }

    @Override
    public boolean isIdProvidedImplicit() {
        return this.isIdProvidedImplicit;
    }

    @Override
    public IndexManagerFactory getIndexManagerFactory() {
        return this.indexManagerFactory;
    }

    static {
        Version.touch();
        log = LoggerFactory.make();
    }
}

