/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.openjpa;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import org.apache.openjpa.persistence.PersistenceMetaDataFactory;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossPersistenceMetaDataFactory
extends PersistenceMetaDataFactory {
    private static final ThreadLocal<PersistenceUnitMetadata> PERSISTENCE_UNIT_METADATA = new ThreadLocal();
    private static final Map<PersistenceUnitMetadata, Set<String>> CACHED_TYPENAMES = new HashMap<PersistenceUnitMetadata, Set<String>>();

    protected Set<String> parsePersistentTypeNames(ClassLoader loader) {
        PersistenceUnitMetadata pu = PERSISTENCE_UNIT_METADATA.get();
        if (pu == null) {
            return Collections.emptySet();
        }
        return this.findPersistenceTypeNames(pu);
    }

    static void setThreadLocalPersistenceUnitMetadata(PersistenceUnitMetadata pu) {
        PERSISTENCE_UNIT_METADATA.set(pu);
    }

    static void clearThreadLocalPersistenceUnitMetadata() {
        PERSISTENCE_UNIT_METADATA.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cleanup(PersistenceUnitMetadata pu) {
        Map<PersistenceUnitMetadata, Set<String>> map = CACHED_TYPENAMES;
        synchronized (map) {
            CACHED_TYPENAMES.remove(pu);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> findPersistenceTypeNames(PersistenceUnitMetadata pu) {
        Map<PersistenceUnitMetadata, Set<String>> map = CACHED_TYPENAMES;
        synchronized (map) {
            Set<String> typeNames = CACHED_TYPENAMES.get(pu);
            if (typeNames != null) {
                return typeNames;
            }
        }
        HashSet<String> persistenceTypeNames = new HashSet<String>();
        for (Map.Entry entry : pu.getAnnotationIndex().entrySet()) {
            List instances = ((Index)entry.getValue()).getAnnotations(DotName.createSimple((String)Entity.class.getName()));
            for (AnnotationInstance instance : instances) {
                AnnotationTarget target = instance.target();
                if (!(target instanceof ClassInfo)) continue;
                ClassInfo classInfo = (ClassInfo)target;
                persistenceTypeNames.add(classInfo.name().toString());
            }
        }
        Map<PersistenceUnitMetadata, Set<String>> map2 = CACHED_TYPENAMES;
        synchronized (map2) {
            CACHED_TYPENAMES.put(pu, persistenceTypeNames);
        }
        return persistenceTypeNames;
    }
}

